/*
 * Decompiled with CFR 0.152.
 */
package io.rhizomatic.inject.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Types;
import io.rhizomatic.api.RhizomaticException;
import io.rhizomatic.api.annotations.Multiplicity;
import io.rhizomatic.inject.guice.LifecycleListener;
import io.rhizomatic.kernel.spi.inject.InstanceManager;
import io.rhizomatic.kernel.spi.layer.LoadedLayer;
import io.rhizomatic.kernel.spi.scan.ScanIndex;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class GuiceInstanceManager
implements InstanceManager {
    private Map<Class<?>, Object> instances = new HashMap();
    private Set<Class<?>> eagerServices = Collections.emptySet();
    private Map<Class<?>, Set<Class<?>>> qualifiedServices = Collections.emptyMap();
    private Injector injector;
    private boolean wired = false;

    public void register(Class<?> type, Object instance) {
        this.instances.put(type, instance);
    }

    public void wire(final ScanIndex scanIndex) {
        AbstractModule injectModule = new AbstractModule(){

            protected void configure() {
                Class<Object> key;
                if (!scanIndex.getInitCallbacks().isEmpty()) {
                    this.bindListener(Matchers.any(), new LifecycleListener(scanIndex.getInitCallbacks()));
                }
                for (Map.Entry<Class<?>, Object> entry : GuiceInstanceManager.this.instances.entrySet()) {
                    key = entry.getKey();
                    this.bind(key).toInstance(entry.getValue());
                }
                if (!scanIndex.getLayers().isEmpty()) {
                    for (LoadedLayer loadedLayer : scanIndex.getLayers()) {
                        ModuleLayer layer = loadedLayer.getModuleLayer();
                        ServiceLoader<Module> guiceModules = ServiceLoader.load(layer, Module.class);
                        guiceModules.forEach(arg_0 -> (this).install(arg_0));
                    }
                }
                for (Map.Entry<Class<Object>, Object> entry : scanIndex.getServiceBindings().entrySet()) {
                    Multibinder builder;
                    if (((List)entry.getValue()).isEmpty()) continue;
                    if (((List)entry.getValue()).size() == 1 && !GuiceInstanceManager.this.isMultiplicity(entry.getKey())) {
                        Class implClass = (Class)((List)entry.getValue()).get(0);
                        this.bind(entry.getKey()).to(implClass).in(Scopes.SINGLETON);
                        continue;
                    }
                    key = entry.getKey();
                    if (key.getTypeParameters().length > 0) {
                        Type[] paramTypes = new Type[key.getTypeParameters().length];
                        for (int i = 0; i < key.getTypeParameters().length; ++i) {
                            paramTypes[i] = Types.subtypeOf(Object.class);
                        }
                        builder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get((Type)Types.newParameterizedType(key, (Type[])paramTypes)));
                    } else {
                        builder = Multibinder.newSetBinder((Binder)this.binder(), key);
                    }
                    for (Class implClass : (List)entry.getValue()) {
                        builder.addBinding().to(implClass).in(Scopes.SINGLETON);
                        this.bind(implClass).in(Scopes.SINGLETON);
                    }
                }
                GuiceInstanceManager.this.eagerServices = scanIndex.getEagerServices();
                GuiceInstanceManager.this.qualifiedServices = scanIndex.getQualifiedServices();
            }
        };
        this.injector = Guice.createInjector((Module[])new Module[]{injectModule});
        this.wired = true;
    }

    public void startInstances() {
        this.checkWired();
        for (Class<?> eagerService : this.eagerServices) {
            this.injector.getInstance(eagerService);
        }
    }

    @Nullable
    public <T> T resolve(Class<T> type) {
        this.checkWired();
        try {
            return (T)this.injector.getInstance(type);
        }
        catch (ConfigurationException e) {
            throw new RhizomaticException((Throwable)e);
        }
    }

    public <T> Set<T> resolveAll(Class<T> type) {
        this.checkWired();
        TypeLiteral literal = TypeLiteral.get((Type)Types.setOf(type));
        try {
            return (Set)this.injector.getInstance(Key.get((TypeLiteral)literal));
        }
        catch (ConfigurationException e) {
            throw new RhizomaticException((Throwable)e);
        }
    }

    public Set<?> resolveQualifiedTypes(Class<?> qualifier) {
        Set<Class<?>> implTypes = this.qualifiedServices.get(qualifier);
        if (implTypes == null) {
            return Collections.emptySet();
        }
        LinkedHashSet instances = new LinkedHashSet();
        for (Class<?> implType : implTypes) {
            Object resolved = this.resolve(implType);
            if (resolved == null) continue;
            instances.add(resolved);
        }
        return instances;
    }

    private void checkWired() {
        if (!this.wired) {
            throw new IllegalStateException(this.getClass().getName() + " not wired");
        }
    }

    private boolean isMultiplicity(Class<?> type) {
        if (type.isAnnotationPresent(Multiplicity.class)) {
            return true;
        }
        for (Class<?> interfaze : type.getInterfaces()) {
            if (!this.isMultiplicity(interfaze)) continue;
            return true;
        }
        return type.getSuperclass() != null && this.isMultiplicity(type.getSuperclass());
    }
}

