/*
 * Decompiled with CFR 0.152.
 */
package io.rhizomatic.inject.scan;

import io.rhizomatic.api.annotations.Eager;
import io.rhizomatic.api.annotations.Init;
import io.rhizomatic.api.annotations.Service;
import io.rhizomatic.kernel.spi.scan.Introspector;
import io.rhizomatic.kernel.spi.scan.ScanIndex;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class InjectionIntrospector
implements Introspector {
    public void introspect(Class<?> type, ScanIndex.Builder builder) {
        if (Modifier.isAbstract(type.getModifiers())) {
            return;
        }
        Service serviceAnnotation = type.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return;
        }
        builder.service(type);
        if (type.getAnnotation(Eager.class) != null) {
            builder.eager(type);
        }
        for (Method method : type.getMethods()) {
            if (method.getAnnotation(Init.class) == null) continue;
            builder.initCallback(type, method);
        }
    }
}

