/*
 * Decompiled with CFR 0.152.
 */
package io.rhizomatic.inject.guice;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.rhizomatic.api.RhizomaticException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class LifecycleListener
implements TypeListener {
    private Map<Class<?>, Method> methodMap;

    public LifecycleListener(Map<Class<?>, Method> methodMap) {
        this.methodMap = methodMap;
    }

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
        Method method = this.methodMap.get(typeLiteral.getRawType());
        if (method == null) {
            return;
        }
        typeEncounter.register(instance -> {
            method.setAccessible(true);
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RhizomaticException((Throwable)e);
            }
        });
    }
}

