package io.resys.hdes.resource.editor.spi.support;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepoAssert.StatusMessage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStatusMessage.builder()}.
 */
@Generated(from = "RepoAssert.StatusMessage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStatusMessage
    implements RepoAssert.StatusMessage {
  private final String id;
  private final String value;
  private final @Nullable String logCode;
  private final @Nullable String logStack;

  private ImmutableStatusMessage(
      String id,
      String value,
      @Nullable String logCode,
      @Nullable String logStack) {
    this.id = id;
    this.value = value;
    this.logCode = logCode;
    this.logStack = logStack;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code logCode} attribute
   */
  @Override
  public Optional<String> getLogCode() {
    return Optional.ofNullable(logCode);
  }

  /**
   * @return The value of the {@code logStack} attribute
   */
  @Override
  public Optional<String> getLogStack() {
    return Optional.ofNullable(logStack);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoAssert.StatusMessage#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusMessage withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableStatusMessage(newValue, this.value, this.logCode, this.logStack);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoAssert.StatusMessage#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatusMessage withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableStatusMessage(this.id, newValue, this.logCode, this.logStack);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepoAssert.StatusMessage#getLogCode() logCode} attribute.
   * @param value The value for logCode
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatusMessage withLogCode(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "logCode");
    if (Objects.equals(this.logCode, newValue)) return this;
    return new ImmutableStatusMessage(this.id, this.value, newValue, this.logStack);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepoAssert.StatusMessage#getLogCode() logCode} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for logCode
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatusMessage withLogCode(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.logCode, value)) return this;
    return new ImmutableStatusMessage(this.id, this.value, value, this.logStack);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RepoAssert.StatusMessage#getLogStack() logStack} attribute.
   * @param value The value for logStack
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatusMessage withLogStack(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "logStack");
    if (Objects.equals(this.logStack, newValue)) return this;
    return new ImmutableStatusMessage(this.id, this.value, this.logCode, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RepoAssert.StatusMessage#getLogStack() logStack} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for logStack
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatusMessage withLogStack(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.logStack, value)) return this;
    return new ImmutableStatusMessage(this.id, this.value, this.logCode, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStatusMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStatusMessage
        && equalTo((ImmutableStatusMessage) another);
  }

  private boolean equalTo(ImmutableStatusMessage another) {
    return id.equals(another.id)
        && value.equals(another.value)
        && Objects.equals(logCode, another.logCode)
        && Objects.equals(logStack, another.logStack);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}, {@code logCode}, {@code logStack}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + Objects.hashCode(logCode);
    h += (h << 5) + Objects.hashCode(logStack);
    return h;
  }

  /**
   * Prints the immutable value {@code StatusMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StatusMessage")
        .omitNullValues()
        .add("id", id)
        .add("value", value)
        .add("logCode", logCode)
        .add("logStack", logStack)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RepoAssert.StatusMessage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StatusMessage instance
   */
  public static ImmutableStatusMessage copyOf(RepoAssert.StatusMessage instance) {
    if (instance instanceof ImmutableStatusMessage) {
      return (ImmutableStatusMessage) instance;
    }
    return ImmutableStatusMessage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStatusMessage ImmutableStatusMessage}.
   * <pre>
   * ImmutableStatusMessage.builder()
   *    .id(String) // required {@link RepoAssert.StatusMessage#getId() id}
   *    .value(String) // required {@link RepoAssert.StatusMessage#getValue() value}
   *    .logCode(String) // optional {@link RepoAssert.StatusMessage#getLogCode() logCode}
   *    .logStack(String) // optional {@link RepoAssert.StatusMessage#getLogStack() logStack}
   *    .build();
   * </pre>
   * @return A new ImmutableStatusMessage builder
   */
  public static ImmutableStatusMessage.Builder builder() {
    return new ImmutableStatusMessage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStatusMessage ImmutableStatusMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepoAssert.StatusMessage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String value;
    private @Nullable String logCode;
    private @Nullable String logStack;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StatusMessage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepoAssert.StatusMessage instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      value(instance.getValue());
      Optional<String> logCodeOptional = instance.getLogCode();
      if (logCodeOptional.isPresent()) {
        logCode(logCodeOptional);
      }
      Optional<String> logStackOptional = instance.getLogStack();
      if (logStackOptional.isPresent()) {
        logStack(logStackOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RepoAssert.StatusMessage#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RepoAssert.StatusMessage#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the optional value {@link RepoAssert.StatusMessage#getLogCode() logCode} to logCode.
     * @param logCode The value for logCode
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder logCode(String logCode) {
      this.logCode = Objects.requireNonNull(logCode, "logCode");
      return this;
    }

    /**
     * Initializes the optional value {@link RepoAssert.StatusMessage#getLogCode() logCode} to logCode.
     * @param logCode The value for logCode
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder logCode(Optional<String> logCode) {
      this.logCode = logCode.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RepoAssert.StatusMessage#getLogStack() logStack} to logStack.
     * @param logStack The value for logStack
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder logStack(String logStack) {
      this.logStack = Objects.requireNonNull(logStack, "logStack");
      return this;
    }

    /**
     * Initializes the optional value {@link RepoAssert.StatusMessage#getLogStack() logStack} to logStack.
     * @param logStack The value for logStack
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder logStack(Optional<String> logStack) {
      this.logStack = logStack.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStatusMessage ImmutableStatusMessage}.
     * @return An immutable instance of StatusMessage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStatusMessage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStatusMessage(id, value, logCode, logStack);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build StatusMessage, some of required attributes are not set " + attributes;
    }
  }
}
