package io.resys.hdes.resource.editor.spi.support;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoWrapper.MongoDbConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoDbConfig.builder()}.
 */
@Generated(from = "MongoWrapper.MongoDbConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMongoDbConfig
    implements MongoWrapper.MongoDbConfig {
  private final String db;
  private final String projects;

  private ImmutableMongoDbConfig(String db, String projects) {
    this.db = db;
    this.projects = projects;
  }

  /**
   * @return The value of the {@code db} attribute
   */
  @Override
  public String getDb() {
    return db;
  }

  /**
   * @return The value of the {@code projects} attribute
   */
  @Override
  public String getProjects() {
    return projects;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getDb() db} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for db
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withDb(String value) {
    String newValue = Objects.requireNonNull(value, "db");
    if (this.db.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(newValue, this.projects);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getProjects() projects} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projects
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withProjects(String value) {
    String newValue = Objects.requireNonNull(value, "projects");
    if (this.projects.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoDbConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoDbConfig
        && equalTo((ImmutableMongoDbConfig) another);
  }

  private boolean equalTo(ImmutableMongoDbConfig another) {
    return db.equals(another.db)
        && projects.equals(another.projects);
  }

  /**
   * Computes a hash code from attributes: {@code db}, {@code projects}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + db.hashCode();
    h += (h << 5) + projects.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoDbConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MongoDbConfig")
        .omitNullValues()
        .add("db", db)
        .add("projects", projects)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoWrapper.MongoDbConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoDbConfig instance
   */
  public static ImmutableMongoDbConfig copyOf(MongoWrapper.MongoDbConfig instance) {
    if (instance instanceof ImmutableMongoDbConfig) {
      return (ImmutableMongoDbConfig) instance;
    }
    return ImmutableMongoDbConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
   * <pre>
   * ImmutableMongoDbConfig.builder()
   *    .db(String) // required {@link MongoWrapper.MongoDbConfig#getDb() db}
   *    .projects(String) // required {@link MongoWrapper.MongoDbConfig#getProjects() projects}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoDbConfig builder
   */
  public static ImmutableMongoDbConfig.Builder builder() {
    return new ImmutableMongoDbConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoWrapper.MongoDbConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DB = 0x1L;
    private static final long INIT_BIT_PROJECTS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String db;
    private @Nullable String projects;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoDbConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MongoWrapper.MongoDbConfig instance) {
      Objects.requireNonNull(instance, "instance");
      db(instance.getDb());
      projects(instance.getProjects());
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getDb() db} attribute.
     * @param db The value for db 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder db(String db) {
      this.db = Objects.requireNonNull(db, "db");
      initBits &= ~INIT_BIT_DB;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getProjects() projects} attribute.
     * @param projects The value for projects 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder projects(String projects) {
      this.projects = Objects.requireNonNull(projects, "projects");
      initBits &= ~INIT_BIT_PROJECTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
     * @return An immutable instance of MongoDbConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoDbConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoDbConfig(db, projects);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DB) != 0) attributes.add("db");
      if ((initBits & INIT_BIT_PROJECTS) != 0) attributes.add("projects");
      return "Cannot build MongoDbConfig, some of required attributes are not set " + attributes;
    }
  }
}
