package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReResource.SnapshotResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSnapshotResource.builder()}.
 */
@Generated(from = "ReResource.SnapshotResource", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSnapshotResource
    implements ReResource.SnapshotResource {
  private final ReResource.Head head;
  private final ReResource.Project project;
  private final ImmutableMap<String, ReResource.Blob> blobs;
  private final ImmutableMap<String, ReResource.Error> errors;

  private ImmutableSnapshotResource(
      ReResource.Head head,
      ReResource.Project project,
      ImmutableMap<String, ReResource.Blob> blobs,
      ImmutableMap<String, ReResource.Error> errors) {
    this.head = head;
    this.project = project;
    this.blobs = blobs;
    this.errors = errors;
  }

  /**
   * @return The value of the {@code head} attribute
   */
  @JsonProperty("head")
  @Override
  public ReResource.Head getHead() {
    return head;
  }

  /**
   * @return The value of the {@code project} attribute
   */
  @JsonProperty("project")
  @Override
  public ReResource.Project getProject() {
    return project;
  }

  /**
   * @return The value of the {@code blobs} attribute
   */
  @JsonProperty("blobs")
  @Override
  public ImmutableMap<String, ReResource.Blob> getBlobs() {
    return blobs;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("errors")
  @Override
  public ImmutableMap<String, ReResource.Error> getErrors() {
    return errors;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.SnapshotResource#getHead() head} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for head
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSnapshotResource withHead(ReResource.Head value) {
    if (this.head == value) return this;
    ReResource.Head newValue = Objects.requireNonNull(value, "head");
    return new ImmutableSnapshotResource(newValue, this.project, this.blobs, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.SnapshotResource#getProject() project} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for project
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSnapshotResource withProject(ReResource.Project value) {
    if (this.project == value) return this;
    ReResource.Project newValue = Objects.requireNonNull(value, "project");
    return new ImmutableSnapshotResource(this.head, newValue, this.blobs, this.errors);
  }

  /**
   * Copy the current immutable object by replacing the {@link ReResource.SnapshotResource#getBlobs() blobs} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the blobs map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSnapshotResource withBlobs(Map<String, ? extends ReResource.Blob> entries) {
    if (this.blobs == entries) return this;
    ImmutableMap<String, ReResource.Blob> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableSnapshotResource(this.head, this.project, newValue, this.errors);
  }

  /**
   * Copy the current immutable object by replacing the {@link ReResource.SnapshotResource#getErrors() errors} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the errors map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSnapshotResource withErrors(Map<String, ? extends ReResource.Error> entries) {
    if (this.errors == entries) return this;
    ImmutableMap<String, ReResource.Error> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableSnapshotResource(this.head, this.project, this.blobs, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSnapshotResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSnapshotResource
        && equalTo((ImmutableSnapshotResource) another);
  }

  private boolean equalTo(ImmutableSnapshotResource another) {
    return head.equals(another.head)
        && project.equals(another.project)
        && blobs.equals(another.blobs)
        && errors.equals(another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code head}, {@code project}, {@code blobs}, {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + head.hashCode();
    h += (h << 5) + project.hashCode();
    h += (h << 5) + blobs.hashCode();
    h += (h << 5) + errors.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SnapshotResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SnapshotResource")
        .omitNullValues()
        .add("head", head)
        .add("project", project)
        .add("blobs", blobs)
        .add("errors", errors)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReResource.SnapshotResource", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReResource.SnapshotResource {
    @Nullable ReResource.Head head;
    @Nullable ReResource.Project project;
    @Nullable Map<String, ReResource.Blob> blobs = ImmutableMap.of();
    @Nullable Map<String, ReResource.Error> errors = ImmutableMap.of();
    @JsonProperty("head")
    public void setHead(ReResource.Head head) {
      this.head = head;
    }
    @JsonProperty("project")
    public void setProject(ReResource.Project project) {
      this.project = project;
    }
    @JsonProperty("blobs")
    public void setBlobs(Map<String, ReResource.Blob> blobs) {
      this.blobs = blobs;
    }
    @JsonProperty("errors")
    public void setErrors(Map<String, ReResource.Error> errors) {
      this.errors = errors;
    }
    @Override
    public ReResource.Head getHead() { throw new UnsupportedOperationException(); }
    @Override
    public ReResource.Project getProject() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, ReResource.Blob> getBlobs() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, ReResource.Error> getErrors() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSnapshotResource fromJson(Json json) {
    ImmutableSnapshotResource.Builder builder = ImmutableSnapshotResource.builder();
    if (json.head != null) {
      builder.head(json.head);
    }
    if (json.project != null) {
      builder.project(json.project);
    }
    if (json.blobs != null) {
      builder.putAllBlobs(json.blobs);
    }
    if (json.errors != null) {
      builder.putAllErrors(json.errors);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReResource.SnapshotResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SnapshotResource instance
   */
  public static ImmutableSnapshotResource copyOf(ReResource.SnapshotResource instance) {
    if (instance instanceof ImmutableSnapshotResource) {
      return (ImmutableSnapshotResource) instance;
    }
    return ImmutableSnapshotResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSnapshotResource ImmutableSnapshotResource}.
   * <pre>
   * ImmutableSnapshotResource.builder()
   *    .head(io.resys.hdes.resource.editor.api.ReResource.Head) // required {@link ReResource.SnapshotResource#getHead() head}
   *    .project(io.resys.hdes.resource.editor.api.ReResource.Project) // required {@link ReResource.SnapshotResource#getProject() project}
   *    .putBlobs|putAllBlobs(String =&gt; io.resys.hdes.resource.editor.api.ReResource.Blob) // {@link ReResource.SnapshotResource#getBlobs() blobs} mappings
   *    .putErrors|putAllErrors(String =&gt; io.resys.hdes.resource.editor.api.ReResource.Error) // {@link ReResource.SnapshotResource#getErrors() errors} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableSnapshotResource builder
   */
  public static ImmutableSnapshotResource.Builder builder() {
    return new ImmutableSnapshotResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSnapshotResource ImmutableSnapshotResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReResource.SnapshotResource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HEAD = 0x1L;
    private static final long INIT_BIT_PROJECT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ReResource.Head head;
    private @Nullable ReResource.Project project;
    private ImmutableMap.Builder<String, ReResource.Blob> blobs = ImmutableMap.builder();
    private ImmutableMap.Builder<String, ReResource.Error> errors = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SnapshotResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.SnapshotResource instance) {
      Objects.requireNonNull(instance, "instance");
      head(instance.getHead());
      project(instance.getProject());
      putAllBlobs(instance.getBlobs());
      putAllErrors(instance.getErrors());
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.SnapshotResource#getHead() head} attribute.
     * @param head The value for head 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("head")
    public final Builder head(ReResource.Head head) {
      this.head = Objects.requireNonNull(head, "head");
      initBits &= ~INIT_BIT_HEAD;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.SnapshotResource#getProject() project} attribute.
     * @param project The value for project 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("project")
    public final Builder project(ReResource.Project project) {
      this.project = Objects.requireNonNull(project, "project");
      initBits &= ~INIT_BIT_PROJECT;
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.SnapshotResource#getBlobs() blobs} map.
     * @param key The key in the blobs map
     * @param value The associated value in the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBlobs(String key, ReResource.Blob value) {
      this.blobs.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.SnapshotResource#getBlobs() blobs} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBlobs(Map.Entry<String, ? extends ReResource.Blob> entry) {
      this.blobs.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ReResource.SnapshotResource#getBlobs() blobs} map. Nulls are not permitted
     * @param entries The entries that will be added to the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("blobs")
    public final Builder blobs(Map<String, ? extends ReResource.Blob> entries) {
      this.blobs = ImmutableMap.builder();
      return putAllBlobs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ReResource.SnapshotResource#getBlobs() blobs} map. Nulls are not permitted
     * @param entries The entries that will be added to the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllBlobs(Map<String, ? extends ReResource.Blob> entries) {
      this.blobs.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.SnapshotResource#getErrors() errors} map.
     * @param key The key in the errors map
     * @param value The associated value in the errors map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putErrors(String key, ReResource.Error value) {
      this.errors.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.SnapshotResource#getErrors() errors} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putErrors(Map.Entry<String, ? extends ReResource.Error> entry) {
      this.errors.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ReResource.SnapshotResource#getErrors() errors} map. Nulls are not permitted
     * @param entries The entries that will be added to the errors map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("errors")
    public final Builder errors(Map<String, ? extends ReResource.Error> entries) {
      this.errors = ImmutableMap.builder();
      return putAllErrors(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ReResource.SnapshotResource#getErrors() errors} map. Nulls are not permitted
     * @param entries The entries that will be added to the errors map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllErrors(Map<String, ? extends ReResource.Error> entries) {
      this.errors.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSnapshotResource ImmutableSnapshotResource}.
     * @return An immutable instance of SnapshotResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSnapshotResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSnapshotResource(head, project, blobs.build(), errors.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HEAD) != 0) attributes.add("head");
      if ((initBits & INIT_BIT_PROJECT) != 0) attributes.add("project");
      return "Cannot build SnapshotResource, some of required attributes are not set " + attributes;
    }
  }
}
