package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReResource.HeadState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHeadState.builder()}.
 */
@Generated(from = "ReResource.HeadState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHeadState implements ReResource.HeadState {
  private final String id;
  private final String head;
  private final Long commits;
  private final ReResource.HeadStateType type;

  private ImmutableHeadState(
      String id,
      String head,
      Long commits,
      ReResource.HeadStateType type) {
    this.id = id;
    this.head = head;
    this.commits = commits;
    this.type = type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code head} attribute
   */
  @JsonProperty("head")
  @Override
  public String getHead() {
    return head;
  }

  /**
   * @return The value of the {@code commits} attribute
   */
  @JsonProperty("commits")
  @Override
  public Long getCommits() {
    return commits;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public ReResource.HeadStateType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.HeadState#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHeadState withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableHeadState(newValue, this.head, this.commits, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.HeadState#getHead() head} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for head
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHeadState withHead(String value) {
    String newValue = Objects.requireNonNull(value, "head");
    if (this.head.equals(newValue)) return this;
    return new ImmutableHeadState(this.id, newValue, this.commits, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.HeadState#getCommits() commits} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commits
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHeadState withCommits(Long value) {
    Long newValue = Objects.requireNonNull(value, "commits");
    if (this.commits.equals(newValue)) return this;
    return new ImmutableHeadState(this.id, this.head, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.HeadState#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHeadState withType(ReResource.HeadStateType value) {
    if (this.type == value) return this;
    ReResource.HeadStateType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableHeadState(this.id, this.head, this.commits, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHeadState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHeadState
        && equalTo((ImmutableHeadState) another);
  }

  private boolean equalTo(ImmutableHeadState another) {
    return id.equals(another.id)
        && head.equals(another.head)
        && commits.equals(another.commits)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code head}, {@code commits}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + head.hashCode();
    h += (h << 5) + commits.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HeadState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HeadState")
        .omitNullValues()
        .add("id", id)
        .add("head", head)
        .add("commits", commits)
        .add("type", type)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReResource.HeadState", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReResource.HeadState {
    @Nullable String id;
    @Nullable String head;
    @Nullable Long commits;
    @Nullable ReResource.HeadStateType type;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("head")
    public void setHead(String head) {
      this.head = head;
    }
    @JsonProperty("commits")
    public void setCommits(Long commits) {
      this.commits = commits;
    }
    @JsonProperty("type")
    public void setType(ReResource.HeadStateType type) {
      this.type = type;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHead() { throw new UnsupportedOperationException(); }
    @Override
    public Long getCommits() { throw new UnsupportedOperationException(); }
    @Override
    public ReResource.HeadStateType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHeadState fromJson(Json json) {
    ImmutableHeadState.Builder builder = ImmutableHeadState.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.head != null) {
      builder.head(json.head);
    }
    if (json.commits != null) {
      builder.commits(json.commits);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReResource.HeadState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HeadState instance
   */
  public static ImmutableHeadState copyOf(ReResource.HeadState instance) {
    if (instance instanceof ImmutableHeadState) {
      return (ImmutableHeadState) instance;
    }
    return ImmutableHeadState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHeadState ImmutableHeadState}.
   * <pre>
   * ImmutableHeadState.builder()
   *    .id(String) // required {@link ReResource.HeadState#getId() id}
   *    .head(String) // required {@link ReResource.HeadState#getHead() head}
   *    .commits(Long) // required {@link ReResource.HeadState#getCommits() commits}
   *    .type(io.resys.hdes.resource.editor.api.ReResource.HeadStateType) // required {@link ReResource.HeadState#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableHeadState builder
   */
  public static ImmutableHeadState.Builder builder() {
    return new ImmutableHeadState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHeadState ImmutableHeadState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReResource.HeadState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HEAD = 0x2L;
    private static final long INIT_BIT_COMMITS = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String head;
    private @Nullable Long commits;
    private @Nullable ReResource.HeadStateType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HeadState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.HeadState instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      head(instance.getHead());
      commits(instance.getCommits());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.HeadState#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.HeadState#getHead() head} attribute.
     * @param head The value for head 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("head")
    public final Builder head(String head) {
      this.head = Objects.requireNonNull(head, "head");
      initBits &= ~INIT_BIT_HEAD;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.HeadState#getCommits() commits} attribute.
     * @param commits The value for commits 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commits")
    public final Builder commits(Long commits) {
      this.commits = Objects.requireNonNull(commits, "commits");
      initBits &= ~INIT_BIT_COMMITS;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.HeadState#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(ReResource.HeadStateType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHeadState ImmutableHeadState}.
     * @return An immutable instance of HeadState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHeadState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHeadState(id, head, commits, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HEAD) != 0) attributes.add("head");
      if ((initBits & INIT_BIT_COMMITS) != 0) attributes.add("commits");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build HeadState, some of required attributes are not set " + attributes;
    }
  }
}
