package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReResource.Error}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableError.builder()}.
 */
@Generated(from = "ReResource.Error", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableError implements ReResource.Error {
  private final String id;
  private final ImmutableList<String> messages;

  private ImmutableError(String id, ImmutableList<String> messages) {
    this.id = id;
    this.messages = messages;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @JsonProperty("messages")
  @Override
  public ImmutableList<String> getMessages() {
    return messages;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Error#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableError(newValue, this.messages);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReResource.Error#getMessages() messages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableError withMessages(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableError(this.id, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ReResource.Error#getMessages() messages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableError withMessages(Iterable<String> elements) {
    if (this.messages == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableError(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableError
        && equalTo((ImmutableError) another);
  }

  private boolean equalTo(ImmutableError another) {
    return id.equals(another.id)
        && messages.equals(another.messages);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code messages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + messages.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Error} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Error")
        .omitNullValues()
        .add("id", id)
        .add("messages", messages)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReResource.Error", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReResource.Error {
    @Nullable String id;
    @Nullable List<String> messages = ImmutableList.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("messages")
    public void setMessages(List<String> messages) {
      this.messages = messages;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getMessages() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableError fromJson(Json json) {
    ImmutableError.Builder builder = ImmutableError.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.messages != null) {
      builder.addAllMessages(json.messages);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReResource.Error} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Error instance
   */
  public static ImmutableError copyOf(ReResource.Error instance) {
    if (instance instanceof ImmutableError) {
      return (ImmutableError) instance;
    }
    return ImmutableError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableError ImmutableError}.
   * <pre>
   * ImmutableError.builder()
   *    .id(String) // required {@link ReResource.Error#getId() id}
   *    .addMessages|addAllMessages(String) // {@link ReResource.Error#getMessages() messages} elements
   *    .build();
   * </pre>
   * @return A new ImmutableError builder
   */
  public static ImmutableError.Builder builder() {
    return new ImmutableError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableError ImmutableError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReResource.Error", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private ImmutableList.Builder<String> messages = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Error} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.Error instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      addAllMessages(instance.getMessages());
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Error#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link ReResource.Error#getMessages() messages} list.
     * @param element A messages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(String element) {
      this.messages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ReResource.Error#getMessages() messages} list.
     * @param elements An array of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(String... elements) {
      this.messages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ReResource.Error#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("messages")
    public final Builder messages(Iterable<String> elements) {
      this.messages = ImmutableList.builder();
      return addAllMessages(elements);
    }

    /**
     * Adds elements to {@link ReResource.Error#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMessages(Iterable<String> elements) {
      this.messages.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableError ImmutableError}.
     * @return An immutable instance of Error
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableError build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableError(id, messages.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Error, some of required attributes are not set " + attributes;
    }
  }
}
