package io.resys.hdes.resource.editor.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReException.ConstraintViolation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConstraintViolation.builder()}.
 */
@Generated(from = "ReException.ConstraintViolation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConstraintViolation
    implements ReException.ConstraintViolation {
  private final String id;
  private final String rev;
  private final ReException.ConstraintType constraint;
  private final ReException.ErrorType type;

  private ImmutableConstraintViolation(
      String id,
      String rev,
      ReException.ConstraintType constraint,
      ReException.ErrorType type) {
    this.id = id;
    this.rev = rev;
    this.constraint = constraint;
    this.type = type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code constraint} attribute
   */
  @Override
  public ReException.ConstraintType getConstraint() {
    return constraint;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public ReException.ErrorType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReException.ConstraintViolation#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstraintViolation withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableConstraintViolation(newValue, this.rev, this.constraint, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReException.ConstraintViolation#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstraintViolation withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableConstraintViolation(this.id, newValue, this.constraint, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReException.ConstraintViolation#getConstraint() constraint} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for constraint
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstraintViolation withConstraint(ReException.ConstraintType value) {
    if (this.constraint == value) return this;
    ReException.ConstraintType newValue = Objects.requireNonNull(value, "constraint");
    if (this.constraint.equals(newValue)) return this;
    return new ImmutableConstraintViolation(this.id, this.rev, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReException.ConstraintViolation#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstraintViolation withType(ReException.ErrorType value) {
    if (this.type == value) return this;
    ReException.ErrorType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableConstraintViolation(this.id, this.rev, this.constraint, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConstraintViolation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConstraintViolation
        && equalTo((ImmutableConstraintViolation) another);
  }

  private boolean equalTo(ImmutableConstraintViolation another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && constraint.equals(another.constraint)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code constraint}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + constraint.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConstraintViolation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConstraintViolation")
        .omitNullValues()
        .add("id", id)
        .add("rev", rev)
        .add("constraint", constraint)
        .add("type", type)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ReException.ConstraintViolation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConstraintViolation instance
   */
  public static ImmutableConstraintViolation copyOf(ReException.ConstraintViolation instance) {
    if (instance instanceof ImmutableConstraintViolation) {
      return (ImmutableConstraintViolation) instance;
    }
    return ImmutableConstraintViolation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConstraintViolation ImmutableConstraintViolation}.
   * <pre>
   * ImmutableConstraintViolation.builder()
   *    .id(String) // required {@link ReException.ConstraintViolation#getId() id}
   *    .rev(String) // required {@link ReException.ConstraintViolation#getRev() rev}
   *    .constraint(io.resys.hdes.resource.editor.api.ReException.ConstraintType) // required {@link ReException.ConstraintViolation#getConstraint() constraint}
   *    .type(io.resys.hdes.resource.editor.api.ReException.ErrorType) // required {@link ReException.ConstraintViolation#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableConstraintViolation builder
   */
  public static ImmutableConstraintViolation.Builder builder() {
    return new ImmutableConstraintViolation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConstraintViolation ImmutableConstraintViolation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReException.ConstraintViolation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_CONSTRAINT = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable ReException.ConstraintType constraint;
    private @Nullable ReException.ErrorType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConstraintViolation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReException.ConstraintViolation instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      constraint(instance.getConstraint());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link ReException.ConstraintViolation#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ReException.ConstraintViolation#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link ReException.ConstraintViolation#getConstraint() constraint} attribute.
     * @param constraint The value for constraint 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder constraint(ReException.ConstraintType constraint) {
      this.constraint = Objects.requireNonNull(constraint, "constraint");
      initBits &= ~INIT_BIT_CONSTRAINT;
      return this;
    }

    /**
     * Initializes the value for the {@link ReException.ConstraintViolation#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(ReException.ErrorType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConstraintViolation ImmutableConstraintViolation}.
     * @return An immutable instance of ConstraintViolation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConstraintViolation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConstraintViolation(id, rev, constraint, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_CONSTRAINT) != 0) attributes.add("constraint");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ConstraintViolation, some of required attributes are not set " + attributes;
    }
  }
}
