package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReResource.Commit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommit.builder()}.
 */
@Generated(from = "ReResource.Commit", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommit implements ReResource.Commit {
  private final String id;
  private final String author;
  private final LocalDateTime dateTime;

  private ImmutableCommit(String id, String author, LocalDateTime dateTime) {
    this.id = id;
    this.author = author;
    this.dateTime = dateTime;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @JsonProperty("author")
  @Override
  public String getAuthor() {
    return author;
  }

  /**
   * @return The value of the {@code dateTime} attribute
   */
  @JsonProperty("dateTime")
  @Override
  public LocalDateTime getDateTime() {
    return dateTime;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Commit#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableCommit(newValue, this.author, this.dateTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Commit#getAuthor() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withAuthor(String value) {
    String newValue = Objects.requireNonNull(value, "author");
    if (this.author.equals(newValue)) return this;
    return new ImmutableCommit(this.id, newValue, this.dateTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Commit#getDateTime() dateTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dateTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withDateTime(LocalDateTime value) {
    if (this.dateTime == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "dateTime");
    return new ImmutableCommit(this.id, this.author, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommit
        && equalTo((ImmutableCommit) another);
  }

  private boolean equalTo(ImmutableCommit another) {
    return id.equals(another.id)
        && author.equals(another.author)
        && dateTime.equals(another.dateTime);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code author}, {@code dateTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + author.hashCode();
    h += (h << 5) + dateTime.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Commit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Commit")
        .omitNullValues()
        .add("id", id)
        .add("author", author)
        .add("dateTime", dateTime)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReResource.Commit", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReResource.Commit {
    @Nullable String id;
    @Nullable String author;
    @Nullable LocalDateTime dateTime;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("author")
    public void setAuthor(String author) {
      this.author = author;
    }
    @JsonProperty("dateTime")
    public void setDateTime(LocalDateTime dateTime) {
      this.dateTime = dateTime;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthor() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getDateTime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommit fromJson(Json json) {
    ImmutableCommit.Builder builder = ImmutableCommit.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.dateTime != null) {
      builder.dateTime(json.dateTime);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReResource.Commit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Commit instance
   */
  public static ImmutableCommit copyOf(ReResource.Commit instance) {
    if (instance instanceof ImmutableCommit) {
      return (ImmutableCommit) instance;
    }
    return ImmutableCommit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommit ImmutableCommit}.
   * <pre>
   * ImmutableCommit.builder()
   *    .id(String) // required {@link ReResource.Commit#getId() id}
   *    .author(String) // required {@link ReResource.Commit#getAuthor() author}
   *    .dateTime(java.time.LocalDateTime) // required {@link ReResource.Commit#getDateTime() dateTime}
   *    .build();
   * </pre>
   * @return A new ImmutableCommit builder
   */
  public static ImmutableCommit.Builder builder() {
    return new ImmutableCommit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommit ImmutableCommit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReResource.Commit", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_AUTHOR = 0x2L;
    private static final long INIT_BIT_DATE_TIME = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String author;
    private @Nullable LocalDateTime dateTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Commit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.Commit instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      author(instance.getAuthor());
      dateTime(instance.getDateTime());
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Commit#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Commit#getAuthor() author} attribute.
     * @param author The value for author 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("author")
    public final Builder author(String author) {
      this.author = Objects.requireNonNull(author, "author");
      initBits &= ~INIT_BIT_AUTHOR;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Commit#getDateTime() dateTime} attribute.
     * @param dateTime The value for dateTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dateTime")
    public final Builder dateTime(LocalDateTime dateTime) {
      this.dateTime = Objects.requireNonNull(dateTime, "dateTime");
      initBits &= ~INIT_BIT_DATE_TIME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommit ImmutableCommit}.
     * @return An immutable instance of Commit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommit build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommit(id, author, dateTime);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_AUTHOR) != 0) attributes.add("author");
      if ((initBits & INIT_BIT_DATE_TIME) != 0) attributes.add("dateTime");
      return "Cannot build Commit, some of required attributes are not set " + attributes;
    }
  }
}
