package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReResource.BlobUpdate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlobUpdate.builder()}.
 */
@Generated(from = "ReResource.BlobUpdate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBlobUpdate implements ReResource.BlobUpdate {
  private final String commit;
  private final String blob;

  private ImmutableBlobUpdate(String commit, String blob) {
    this.commit = commit;
    this.blob = blob;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @JsonProperty("commit")
  @Override
  public String getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code blob} attribute
   */
  @JsonProperty("blob")
  @Override
  public String getBlob() {
    return blob;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.BlobUpdate#getCommit() commit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobUpdate withCommit(String value) {
    String newValue = Objects.requireNonNull(value, "commit");
    if (this.commit.equals(newValue)) return this;
    return new ImmutableBlobUpdate(newValue, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.BlobUpdate#getBlob() blob} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blob
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobUpdate withBlob(String value) {
    String newValue = Objects.requireNonNull(value, "blob");
    if (this.blob.equals(newValue)) return this;
    return new ImmutableBlobUpdate(this.commit, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlobUpdate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlobUpdate
        && equalTo((ImmutableBlobUpdate) another);
  }

  private boolean equalTo(ImmutableBlobUpdate another) {
    return commit.equals(another.commit)
        && blob.equals(another.blob);
  }

  /**
   * Computes a hash code from attributes: {@code commit}, {@code blob}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + blob.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BlobUpdate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BlobUpdate")
        .omitNullValues()
        .add("commit", commit)
        .add("blob", blob)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReResource.BlobUpdate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReResource.BlobUpdate {
    @Nullable String commit;
    @Nullable String blob;
    @JsonProperty("commit")
    public void setCommit(String commit) {
      this.commit = commit;
    }
    @JsonProperty("blob")
    public void setBlob(String blob) {
      this.blob = blob;
    }
    @Override
    public String getCommit() { throw new UnsupportedOperationException(); }
    @Override
    public String getBlob() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBlobUpdate fromJson(Json json) {
    ImmutableBlobUpdate.Builder builder = ImmutableBlobUpdate.builder();
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    if (json.blob != null) {
      builder.blob(json.blob);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReResource.BlobUpdate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlobUpdate instance
   */
  public static ImmutableBlobUpdate copyOf(ReResource.BlobUpdate instance) {
    if (instance instanceof ImmutableBlobUpdate) {
      return (ImmutableBlobUpdate) instance;
    }
    return ImmutableBlobUpdate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlobUpdate ImmutableBlobUpdate}.
   * <pre>
   * ImmutableBlobUpdate.builder()
   *    .commit(String) // required {@link ReResource.BlobUpdate#getCommit() commit}
   *    .blob(String) // required {@link ReResource.BlobUpdate#getBlob() blob}
   *    .build();
   * </pre>
   * @return A new ImmutableBlobUpdate builder
   */
  public static ImmutableBlobUpdate.Builder builder() {
    return new ImmutableBlobUpdate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlobUpdate ImmutableBlobUpdate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReResource.BlobUpdate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COMMIT = 0x1L;
    private static final long INIT_BIT_BLOB = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String commit;
    private @Nullable String blob;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.hdes.resource.editor.api.ReResource.BatchMutator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.BatchMutator instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.hdes.resource.editor.api.ReResource.BlobUpdate} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.BlobUpdate instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ReResource.BatchMutator) {
        ReResource.BatchMutator instance = (ReResource.BatchMutator) object;
        commit(instance.getCommit());
      }
      if (object instanceof ReResource.BlobUpdate) {
        ReResource.BlobUpdate instance = (ReResource.BlobUpdate) object;
        blob(instance.getBlob());
      }
    }

    /**
     * Initializes the value for the {@link ReResource.BlobUpdate#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commit")
    public final Builder commit(String commit) {
      this.commit = Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.BlobUpdate#getBlob() blob} attribute.
     * @param blob The value for blob 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("blob")
    public final Builder blob(String blob) {
      this.blob = Objects.requireNonNull(blob, "blob");
      initBits &= ~INIT_BIT_BLOB;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlobUpdate ImmutableBlobUpdate}.
     * @return An immutable instance of BlobUpdate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlobUpdate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBlobUpdate(commit, blob);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_BLOB) != 0) attributes.add("blob");
      return "Cannot build BlobUpdate, some of required attributes are not set " + attributes;
    }
  }
}
