package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReResource.ProjectResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProjectResource.builder()}.
 */
@Generated(from = "ReResource.ProjectResource", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProjectResource
    implements ReResource.ProjectResource {
  private final ReResource.Project project;
  private final ImmutableMap<String, ReResource.Head> heads;
  private final ImmutableMap<String, ReResource.HeadState> states;

  private ImmutableProjectResource(
      ReResource.Project project,
      ImmutableMap<String, ReResource.Head> heads,
      ImmutableMap<String, ReResource.HeadState> states) {
    this.project = project;
    this.heads = heads;
    this.states = states;
  }

  /**
   * @return The value of the {@code project} attribute
   */
  @JsonProperty("project")
  @Override
  public ReResource.Project getProject() {
    return project;
  }

  /**
   * @return The value of the {@code heads} attribute
   */
  @JsonProperty("heads")
  @Override
  public ImmutableMap<String, ReResource.Head> getHeads() {
    return heads;
  }

  /**
   * @return The value of the {@code states} attribute
   */
  @JsonProperty("states")
  @Override
  public ImmutableMap<String, ReResource.HeadState> getStates() {
    return states;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.ProjectResource#getProject() project} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for project
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectResource withProject(ReResource.Project value) {
    if (this.project == value) return this;
    ReResource.Project newValue = Objects.requireNonNull(value, "project");
    return new ImmutableProjectResource(newValue, this.heads, this.states);
  }

  /**
   * Copy the current immutable object by replacing the {@link ReResource.ProjectResource#getHeads() heads} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the heads map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProjectResource withHeads(Map<String, ? extends ReResource.Head> entries) {
    if (this.heads == entries) return this;
    ImmutableMap<String, ReResource.Head> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableProjectResource(this.project, newValue, this.states);
  }

  /**
   * Copy the current immutable object by replacing the {@link ReResource.ProjectResource#getStates() states} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the states map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProjectResource withStates(Map<String, ? extends ReResource.HeadState> entries) {
    if (this.states == entries) return this;
    ImmutableMap<String, ReResource.HeadState> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableProjectResource(this.project, this.heads, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProjectResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProjectResource
        && equalTo((ImmutableProjectResource) another);
  }

  private boolean equalTo(ImmutableProjectResource another) {
    return project.equals(another.project)
        && heads.equals(another.heads)
        && states.equals(another.states);
  }

  /**
   * Computes a hash code from attributes: {@code project}, {@code heads}, {@code states}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + project.hashCode();
    h += (h << 5) + heads.hashCode();
    h += (h << 5) + states.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProjectResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProjectResource")
        .omitNullValues()
        .add("project", project)
        .add("heads", heads)
        .add("states", states)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReResource.ProjectResource", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReResource.ProjectResource {
    @Nullable ReResource.Project project;
    @Nullable Map<String, ReResource.Head> heads = ImmutableMap.of();
    @Nullable Map<String, ReResource.HeadState> states = ImmutableMap.of();
    @JsonProperty("project")
    public void setProject(ReResource.Project project) {
      this.project = project;
    }
    @JsonProperty("heads")
    public void setHeads(Map<String, ReResource.Head> heads) {
      this.heads = heads;
    }
    @JsonProperty("states")
    public void setStates(Map<String, ReResource.HeadState> states) {
      this.states = states;
    }
    @Override
    public ReResource.Project getProject() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, ReResource.Head> getHeads() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, ReResource.HeadState> getStates() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableProjectResource fromJson(Json json) {
    ImmutableProjectResource.Builder builder = ImmutableProjectResource.builder();
    if (json.project != null) {
      builder.project(json.project);
    }
    if (json.heads != null) {
      builder.putAllHeads(json.heads);
    }
    if (json.states != null) {
      builder.putAllStates(json.states);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReResource.ProjectResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProjectResource instance
   */
  public static ImmutableProjectResource copyOf(ReResource.ProjectResource instance) {
    if (instance instanceof ImmutableProjectResource) {
      return (ImmutableProjectResource) instance;
    }
    return ImmutableProjectResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProjectResource ImmutableProjectResource}.
   * <pre>
   * ImmutableProjectResource.builder()
   *    .project(io.resys.hdes.resource.editor.api.ReResource.Project) // required {@link ReResource.ProjectResource#getProject() project}
   *    .putHeads|putAllHeads(String =&gt; io.resys.hdes.resource.editor.api.ReResource.Head) // {@link ReResource.ProjectResource#getHeads() heads} mappings
   *    .putStates|putAllStates(String =&gt; io.resys.hdes.resource.editor.api.ReResource.HeadState) // {@link ReResource.ProjectResource#getStates() states} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableProjectResource builder
   */
  public static ImmutableProjectResource.Builder builder() {
    return new ImmutableProjectResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProjectResource ImmutableProjectResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReResource.ProjectResource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROJECT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ReResource.Project project;
    private ImmutableMap.Builder<String, ReResource.Head> heads = ImmutableMap.builder();
    private ImmutableMap.Builder<String, ReResource.HeadState> states = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProjectResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.ProjectResource instance) {
      Objects.requireNonNull(instance, "instance");
      project(instance.getProject());
      putAllHeads(instance.getHeads());
      putAllStates(instance.getStates());
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.ProjectResource#getProject() project} attribute.
     * @param project The value for project 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("project")
    public final Builder project(ReResource.Project project) {
      this.project = Objects.requireNonNull(project, "project");
      initBits &= ~INIT_BIT_PROJECT;
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.ProjectResource#getHeads() heads} map.
     * @param key The key in the heads map
     * @param value The associated value in the heads map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHeads(String key, ReResource.Head value) {
      this.heads.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.ProjectResource#getHeads() heads} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHeads(Map.Entry<String, ? extends ReResource.Head> entry) {
      this.heads.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ReResource.ProjectResource#getHeads() heads} map. Nulls are not permitted
     * @param entries The entries that will be added to the heads map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("heads")
    public final Builder heads(Map<String, ? extends ReResource.Head> entries) {
      this.heads = ImmutableMap.builder();
      return putAllHeads(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ReResource.ProjectResource#getHeads() heads} map. Nulls are not permitted
     * @param entries The entries that will be added to the heads map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHeads(Map<String, ? extends ReResource.Head> entries) {
      this.heads.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.ProjectResource#getStates() states} map.
     * @param key The key in the states map
     * @param value The associated value in the states map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putStates(String key, ReResource.HeadState value) {
      this.states.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.ProjectResource#getStates() states} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putStates(Map.Entry<String, ? extends ReResource.HeadState> entry) {
      this.states.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ReResource.ProjectResource#getStates() states} map. Nulls are not permitted
     * @param entries The entries that will be added to the states map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("states")
    public final Builder states(Map<String, ? extends ReResource.HeadState> entries) {
      this.states = ImmutableMap.builder();
      return putAllStates(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ReResource.ProjectResource#getStates() states} map. Nulls are not permitted
     * @param entries The entries that will be added to the states map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllStates(Map<String, ? extends ReResource.HeadState> entries) {
      this.states.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableProjectResource ImmutableProjectResource}.
     * @return An immutable instance of ProjectResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProjectResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProjectResource(project, heads.build(), states.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROJECT) != 0) attributes.add("project");
      return "Cannot build ProjectResource, some of required attributes are not set " + attributes;
    }
  }
}
