package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReResource.Head}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHead.builder()}.
 */
@Generated(from = "ReResource.Head", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHead implements ReResource.Head {
  private final String id;
  private final String name;
  private final ReResource.Commit commit;

  private ImmutableHead(
      String id,
      String name,
      ReResource.Commit commit) {
    this.id = id;
    this.name = name;
    this.commit = commit;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @JsonProperty("commit")
  @Override
  public ReResource.Commit getCommit() {
    return commit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Head#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHead withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableHead(newValue, this.name, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Head#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHead withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableHead(this.id, newValue, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Head#getCommit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHead withCommit(ReResource.Commit value) {
    if (this.commit == value) return this;
    ReResource.Commit newValue = Objects.requireNonNull(value, "commit");
    return new ImmutableHead(this.id, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHead} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHead
        && equalTo((ImmutableHead) another);
  }

  private boolean equalTo(ImmutableHead another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && commit.equals(another.commit);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code commit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + commit.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Head} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Head")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("commit", commit)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReResource.Head", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReResource.Head {
    @Nullable String id;
    @Nullable String name;
    @Nullable ReResource.Commit commit;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("commit")
    public void setCommit(ReResource.Commit commit) {
      this.commit = commit;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ReResource.Commit getCommit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHead fromJson(Json json) {
    ImmutableHead.Builder builder = ImmutableHead.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReResource.Head} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Head instance
   */
  public static ImmutableHead copyOf(ReResource.Head instance) {
    if (instance instanceof ImmutableHead) {
      return (ImmutableHead) instance;
    }
    return ImmutableHead.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHead ImmutableHead}.
   * <pre>
   * ImmutableHead.builder()
   *    .id(String) // required {@link ReResource.Head#getId() id}
   *    .name(String) // required {@link ReResource.Head#getName() name}
   *    .commit(io.resys.hdes.resource.editor.api.ReResource.Commit) // required {@link ReResource.Head#getCommit() commit}
   *    .build();
   * </pre>
   * @return A new ImmutableHead builder
   */
  public static ImmutableHead.Builder builder() {
    return new ImmutableHead.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHead ImmutableHead}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReResource.Head", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_COMMIT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable ReResource.Commit commit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Head} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.Head instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      commit(instance.getCommit());
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Head#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Head#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Head#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commit")
    public final Builder commit(ReResource.Commit commit) {
      this.commit = Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHead ImmutableHead}.
     * @return An immutable instance of Head
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHead build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHead(id, name, commit);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      return "Cannot build Head, some of required attributes are not set " + attributes;
    }
  }
}
