package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReResource.Blob}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlob.builder()}.
 */
@Generated(from = "ReResource.Blob", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBlob implements ReResource.Blob {
  private final String id;
  private final String name;
  private final String src;
  private final ImmutableMap<String, Serializable> ast;

  private ImmutableBlob(
      String id,
      String name,
      String src,
      ImmutableMap<String, Serializable> ast) {
    this.id = id;
    this.name = name;
    this.src = src;
    this.ast = ast;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code src} attribute
   */
  @JsonProperty("src")
  @Override
  public String getSrc() {
    return src;
  }

  /**
   * @return The value of the {@code ast} attribute
   */
  @JsonProperty("ast")
  @Override
  public ImmutableMap<String, Serializable> getAst() {
    return ast;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Blob#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableBlob(newValue, this.name, this.src, this.ast);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Blob#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableBlob(this.id, newValue, this.src, this.ast);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReResource.Blob#getSrc() src} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for src
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withSrc(String value) {
    String newValue = Objects.requireNonNull(value, "src");
    if (this.src.equals(newValue)) return this;
    return new ImmutableBlob(this.id, this.name, newValue, this.ast);
  }

  /**
   * Copy the current immutable object by replacing the {@link ReResource.Blob#getAst() ast} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the ast map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlob withAst(Map<String, ? extends Serializable> entries) {
    if (this.ast == entries) return this;
    ImmutableMap<String, Serializable> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableBlob(this.id, this.name, this.src, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlob} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlob
        && equalTo((ImmutableBlob) another);
  }

  private boolean equalTo(ImmutableBlob another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && src.equals(another.src)
        && ast.equals(another.ast);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code src}, {@code ast}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + src.hashCode();
    h += (h << 5) + ast.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Blob} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Blob")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("src", src)
        .add("ast", ast)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReResource.Blob", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReResource.Blob {
    @Nullable String id;
    @Nullable String name;
    @Nullable String src;
    @Nullable Map<String, Serializable> ast = ImmutableMap.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("src")
    public void setSrc(String src) {
      this.src = src;
    }
    @JsonProperty("ast")
    public void setAst(Map<String, Serializable> ast) {
      this.ast = ast;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSrc() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Serializable> getAst() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBlob fromJson(Json json) {
    ImmutableBlob.Builder builder = ImmutableBlob.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.src != null) {
      builder.src(json.src);
    }
    if (json.ast != null) {
      builder.putAllAst(json.ast);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReResource.Blob} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Blob instance
   */
  public static ImmutableBlob copyOf(ReResource.Blob instance) {
    if (instance instanceof ImmutableBlob) {
      return (ImmutableBlob) instance;
    }
    return ImmutableBlob.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlob ImmutableBlob}.
   * <pre>
   * ImmutableBlob.builder()
   *    .id(String) // required {@link ReResource.Blob#getId() id}
   *    .name(String) // required {@link ReResource.Blob#getName() name}
   *    .src(String) // required {@link ReResource.Blob#getSrc() src}
   *    .putAst|putAllAst(String =&gt; java.io.Serializable) // {@link ReResource.Blob#getAst() ast} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableBlob builder
   */
  public static ImmutableBlob.Builder builder() {
    return new ImmutableBlob.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlob ImmutableBlob}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReResource.Blob", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_SRC = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String src;
    private ImmutableMap.Builder<String, Serializable> ast = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Blob} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReResource.Blob instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      src(instance.getSrc());
      putAllAst(instance.getAst());
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Blob#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Blob#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ReResource.Blob#getSrc() src} attribute.
     * @param src The value for src 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("src")
    public final Builder src(String src) {
      this.src = Objects.requireNonNull(src, "src");
      initBits &= ~INIT_BIT_SRC;
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.Blob#getAst() ast} map.
     * @param key The key in the ast map
     * @param value The associated value in the ast map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAst(String key, Serializable value) {
      this.ast.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ReResource.Blob#getAst() ast} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAst(Map.Entry<String, ? extends Serializable> entry) {
      this.ast.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ReResource.Blob#getAst() ast} map. Nulls are not permitted
     * @param entries The entries that will be added to the ast map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ast")
    public final Builder ast(Map<String, ? extends Serializable> entries) {
      this.ast = ImmutableMap.builder();
      return putAllAst(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ReResource.Blob#getAst() ast} map. Nulls are not permitted
     * @param entries The entries that will be added to the ast map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllAst(Map<String, ? extends Serializable> entries) {
      this.ast.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlob ImmutableBlob}.
     * @return An immutable instance of Blob
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlob build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBlob(id, name, src, ast.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SRC) != 0) attributes.add("src");
      return "Cannot build Blob, some of required attributes are not set " + attributes;
    }
  }
}
