/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.spi.support;

import io.resys.hdes.resource.editor.spi.support.ReRepoException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Hex;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoAssert {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepoAssert.class);

    public static String exceptionHash(String msg) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(msg.getBytes(Charset.forName("UTF-8")));
            byte[] digest = md5.digest();
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn("MD5 Digester not found, falling back to timestamp hash", (Throwable)ex);
            long timestamp = System.currentTimeMillis();
            return Long.toHexString(timestamp);
        }
    }

    public static void notEmptyAtLeastOne(Supplier<String> message, String ... fields) {
        for (String field : fields) {
            if (field == null || field.isBlank()) continue;
            return;
        }
        throw new ReRepoException(RepoAssert.getMessage(message));
    }

    public static void notEmptyAll(Supplier<String> message, String ... fields) {
        for (String field : fields) {
            if (field != null && !field.isBlank()) continue;
            throw new ReRepoException(RepoAssert.getMessage(message));
        }
    }

    public static void notNull(Object object, Supplier<String> message) {
        if (object == null) {
            throw new ReRepoException(RepoAssert.getMessage(message));
        }
    }

    public static void notEmpty(List<?> object, Supplier<String> message) {
        if (object == null || object.isEmpty()) {
            throw new ReRepoException(RepoAssert.getMessage(message));
        }
    }

    public static void notEmpty(String object, Supplier<String> message) {
        if (object == null || object.isBlank()) {
            throw new ReRepoException(RepoAssert.getMessage(message));
        }
    }

    public static void isTrue(boolean expression, Supplier<String> message) {
        if (!expression) {
            throw new ReRepoException(RepoAssert.getMessage(message));
        }
    }

    public static void fail(Supplier<String> message) {
        throw new ReRepoException(RepoAssert.getMessage(message));
    }

    private static String getMessage(Supplier<String> supplier) {
        return supplier != null ? supplier.get() : null;
    }

    @Value.Immutable
    public static interface StatusMessage {
        public String getId();

        public String getValue();

        public Optional<String> getLogCode();

        public Optional<String> getLogStack();
    }
}

