/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.spi.support;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.spi.support.RepoAssert;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepoAssert.StatusMessage", generator="Immutables")
@Immutable
public final class ImmutableStatusMessage
implements RepoAssert.StatusMessage {
    private final String id;
    private final String value;
    @Nullable
    private final String logCode;
    @Nullable
    private final String logStack;

    private ImmutableStatusMessage(String id, String value, @Nullable String logCode, @Nullable String logStack) {
        this.id = id;
        this.value = value;
        this.logCode = logCode;
        this.logStack = logStack;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Optional<String> getLogCode() {
        return Optional.ofNullable(this.logCode);
    }

    @Override
    public Optional<String> getLogStack() {
        return Optional.ofNullable(this.logStack);
    }

    public final ImmutableStatusMessage withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableStatusMessage(newValue, this.value, this.logCode, this.logStack);
    }

    public final ImmutableStatusMessage withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableStatusMessage(this.id, newValue, this.logCode, this.logStack);
    }

    public final ImmutableStatusMessage withLogCode(String value) {
        String newValue = Objects.requireNonNull(value, "logCode");
        if (Objects.equals(this.logCode, newValue)) {
            return this;
        }
        return new ImmutableStatusMessage(this.id, this.value, newValue, this.logStack);
    }

    public final ImmutableStatusMessage withLogCode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.logCode, value)) {
            return this;
        }
        return new ImmutableStatusMessage(this.id, this.value, value, this.logStack);
    }

    public final ImmutableStatusMessage withLogStack(String value) {
        String newValue = Objects.requireNonNull(value, "logStack");
        if (Objects.equals(this.logStack, newValue)) {
            return this;
        }
        return new ImmutableStatusMessage(this.id, this.value, this.logCode, newValue);
    }

    public final ImmutableStatusMessage withLogStack(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.logStack, value)) {
            return this;
        }
        return new ImmutableStatusMessage(this.id, this.value, this.logCode, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatusMessage && this.equalTo((ImmutableStatusMessage)another);
    }

    private boolean equalTo(ImmutableStatusMessage another) {
        return this.id.equals(another.id) && this.value.equals(another.value) && Objects.equals(this.logCode, another.logCode) && Objects.equals(this.logStack, another.logStack);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.logCode);
        h += (h << 5) + Objects.hashCode(this.logStack);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StatusMessage").omitNullValues().add("id", (Object)this.id).add("value", (Object)this.value).add("logCode", (Object)this.logCode).add("logStack", (Object)this.logStack).toString();
    }

    public static ImmutableStatusMessage copyOf(RepoAssert.StatusMessage instance) {
        if (instance instanceof ImmutableStatusMessage) {
            return (ImmutableStatusMessage)instance;
        }
        return ImmutableStatusMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepoAssert.StatusMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String value;
        @Nullable
        private String logCode;
        @Nullable
        private String logStack;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepoAssert.StatusMessage instance) {
            Optional<String> logStackOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.value(instance.getValue());
            Optional<String> logCodeOptional = instance.getLogCode();
            if (logCodeOptional.isPresent()) {
                this.logCode(logCodeOptional);
            }
            if ((logStackOptional = instance.getLogStack()).isPresent()) {
                this.logStack(logStackOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logCode(String logCode) {
            this.logCode = Objects.requireNonNull(logCode, "logCode");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logCode(Optional<String> logCode) {
            this.logCode = logCode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logStack(String logStack) {
            this.logStack = Objects.requireNonNull(logStack, "logStack");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logStack(Optional<String> logStack) {
            this.logStack = logStack.orElse(null);
            return this;
        }

        public ImmutableStatusMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatusMessage(this.id, this.value, this.logCode, this.logStack);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build StatusMessage, some of required attributes are not set " + attributes;
        }
    }
}

