/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.spi.support;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import io.resys.hdes.resource.editor.spi.support.MongoWrapper;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MongoWrapper", generator="Immutables")
@Immutable
public final class ImmutableMongoWrapper
implements MongoWrapper {
    private final MongoClient client;
    private final MongoWrapper.MongoDbConfig config;
    private final MongoDatabase db;

    private ImmutableMongoWrapper(MongoClient client, MongoWrapper.MongoDbConfig config, MongoDatabase db) {
        this.client = client;
        this.config = config;
        this.db = db;
    }

    @Override
    public MongoClient getClient() {
        return this.client;
    }

    @Override
    public MongoWrapper.MongoDbConfig getConfig() {
        return this.config;
    }

    @Override
    public MongoDatabase getDb() {
        return this.db;
    }

    public final ImmutableMongoWrapper withClient(MongoClient value) {
        if (this.client == value) {
            return this;
        }
        MongoClient newValue = Objects.requireNonNull(value, "client");
        return new ImmutableMongoWrapper(newValue, this.config, this.db);
    }

    public final ImmutableMongoWrapper withConfig(MongoWrapper.MongoDbConfig value) {
        if (this.config == value) {
            return this;
        }
        MongoWrapper.MongoDbConfig newValue = Objects.requireNonNull(value, "config");
        return new ImmutableMongoWrapper(this.client, newValue, this.db);
    }

    public final ImmutableMongoWrapper withDb(MongoDatabase value) {
        if (this.db == value) {
            return this;
        }
        MongoDatabase newValue = Objects.requireNonNull(value, "db");
        return new ImmutableMongoWrapper(this.client, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoWrapper && this.equalTo((ImmutableMongoWrapper)another);
    }

    private boolean equalTo(ImmutableMongoWrapper another) {
        return this.client.equals(another.client) && this.config.equals(another.config) && this.db.equals(another.db);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.db.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoWrapper").omitNullValues().add("client", (Object)this.client).add("config", (Object)this.config).add("db", (Object)this.db).toString();
    }

    public static ImmutableMongoWrapper copyOf(MongoWrapper instance) {
        if (instance instanceof ImmutableMongoWrapper) {
            return (ImmutableMongoWrapper)instance;
        }
        return ImmutableMongoWrapper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoWrapper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT = 1L;
        private static final long INIT_BIT_CONFIG = 2L;
        private static final long INIT_BIT_DB = 4L;
        private long initBits = 7L;
        @Nullable
        private MongoClient client;
        @Nullable
        private MongoWrapper.MongoDbConfig config;
        @Nullable
        private MongoDatabase db;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoWrapper instance) {
            Objects.requireNonNull(instance, "instance");
            this.client(instance.getClient());
            this.config(instance.getConfig());
            this.db(instance.getDb());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(MongoClient client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(MongoWrapper.MongoDbConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(MongoDatabase db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMongoWrapper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoWrapper(this.client, this.config, this.db);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("client");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("db");
            }
            return "Cannot build MongoWrapper, some of required attributes are not set " + attributes;
        }
    }
}

