/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.spi.support;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.spi.support.MongoWrapper;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MongoWrapper.MongoDbConfig", generator="Immutables")
@Immutable
public final class ImmutableMongoDbConfig
implements MongoWrapper.MongoDbConfig {
    private final String db;
    private final String projects;

    private ImmutableMongoDbConfig(String db, String projects) {
        this.db = db;
        this.projects = projects;
    }

    @Override
    public String getDb() {
        return this.db;
    }

    @Override
    public String getProjects() {
        return this.projects;
    }

    public final ImmutableMongoDbConfig withDb(String value) {
        String newValue = Objects.requireNonNull(value, "db");
        if (this.db.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoDbConfig(newValue, this.projects);
    }

    public final ImmutableMongoDbConfig withProjects(String value) {
        String newValue = Objects.requireNonNull(value, "projects");
        if (this.projects.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoDbConfig(this.db, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoDbConfig && this.equalTo((ImmutableMongoDbConfig)another);
    }

    private boolean equalTo(ImmutableMongoDbConfig another) {
        return this.db.equals(another.db) && this.projects.equals(another.projects);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.projects.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoDbConfig").omitNullValues().add("db", (Object)this.db).add("projects", (Object)this.projects).toString();
    }

    public static ImmutableMongoDbConfig copyOf(MongoWrapper.MongoDbConfig instance) {
        if (instance instanceof ImmutableMongoDbConfig) {
            return (ImmutableMongoDbConfig)instance;
        }
        return ImmutableMongoDbConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoWrapper.MongoDbConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long INIT_BIT_PROJECTS = 2L;
        private long initBits = 3L;
        @Nullable
        private String db;
        @Nullable
        private String projects;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoWrapper.MongoDbConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.getDb());
            this.projects(instance.getProjects());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(String db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projects(String projects) {
            this.projects = Objects.requireNonNull(projects, "projects");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMongoDbConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoDbConfig(this.db, this.projects);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projects");
            }
            return "Cannot build MongoDbConfig, some of required attributes are not set " + attributes;
        }
    }
}

