/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.spi;

import io.resys.hdes.resource.editor.api.ReRepository;
import io.resys.hdes.resource.editor.spi.support.ImmutableMongoDbConfig;
import io.resys.hdes.resource.editor.spi.support.MongoWrapper;
import io.resys.hdes.resource.editor.spi.support.RepoAssert;

public class MongoReRepository
implements ReRepository {
    private final MongoWrapper.MongoDbConfig config;
    private final MongoWrapper.MongoTransaction tx;

    public MongoReRepository(MongoWrapper.MongoDbConfig config, MongoWrapper.MongoTransaction tx) {
        this.config = config;
        this.tx = tx;
    }

    @Override
    public ReRepository.ReUpdate update() {
        return null;
    }

    @Override
    public ReRepository.ReQuery query() {
        return null;
    }

    public static Config config() {
        return new Config();
    }

    public static class Config {
        private MongoWrapper.MongoTransaction transaction;
        private MongoWrapper.MongoDbConfig config;
        private String dbName;

        public Config transaction(MongoWrapper.MongoTransaction transaction) {
            this.transaction = transaction;
            return this;
        }

        public Config config(MongoWrapper.MongoDbConfig config) {
            this.config = config;
            return this;
        }

        public Config dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public MongoReRepository build() {
            RepoAssert.notNull(this.transaction, () -> "transaction not defined!");
            RepoAssert.notEmpty(this.dbName, () -> "dbName not defined!");
            if (this.config == null) {
                this.config = ImmutableMongoDbConfig.builder().db(this.dbName).projects("projects").build();
            }
            return new MongoReRepository(this.config, this.transaction);
        }
    }
}

