/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.resys.hdes.resource.editor.api.ImmutableBlob;
import io.resys.hdes.resource.editor.api.ImmutableBlobUpdate;
import io.resys.hdes.resource.editor.api.ImmutableCommit;
import io.resys.hdes.resource.editor.api.ImmutableError;
import io.resys.hdes.resource.editor.api.ImmutableHead;
import io.resys.hdes.resource.editor.api.ImmutableHeadState;
import io.resys.hdes.resource.editor.api.ImmutableProject;
import io.resys.hdes.resource.editor.api.ImmutableProjectResource;
import io.resys.hdes.resource.editor.api.ImmutableSnapshotResource;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;

public interface ReResource
extends Serializable {

    public static enum HeadStateType {
        ahead,
        behind,
        same;

    }

    @JsonSerialize(as=ImmutableCommit.class)
    @JsonDeserialize(as=ImmutableCommit.class)
    @Value.Immutable
    public static interface Commit {
        public String getId();

        public String getAuthor();

        public LocalDateTime getDateTime();
    }

    @JsonSerialize(as=ImmutableHeadState.class)
    @JsonDeserialize(as=ImmutableHeadState.class)
    @Value.Immutable
    public static interface HeadState {
        public String getId();

        public String getHead();

        public Long getCommits();

        public HeadStateType getType();
    }

    @JsonSerialize(as=ImmutableHead.class)
    @JsonDeserialize(as=ImmutableHead.class)
    @Value.Immutable
    public static interface Head {
        public String getId();

        public String getName();

        public Commit getCommit();
    }

    @JsonSerialize(as=ImmutableProject.class)
    @JsonDeserialize(as=ImmutableProject.class)
    @Value.Immutable
    public static interface Project
    extends Serializable {
        public String getId();

        public String getRev();

        public String getName();

        public LocalDateTime getCreated();
    }

    @JsonSerialize(as=ImmutableProjectResource.class)
    @JsonDeserialize(as=ImmutableProjectResource.class)
    @Value.Immutable
    public static interface ProjectResource
    extends ReResource {
        public Project getProject();

        public Map<String, Head> getHeads();

        public Map<String, HeadState> getStates();
    }

    @JsonSerialize(as=ImmutableBlob.class)
    @JsonDeserialize(as=ImmutableBlob.class)
    @Value.Immutable
    public static interface Blob
    extends Serializable {
        public String getId();

        public String getName();

        public String getSrc();

        public Map<String, Serializable> getAst();
    }

    @JsonSerialize(as=ImmutableError.class)
    @JsonDeserialize(as=ImmutableError.class)
    @Value.Immutable
    public static interface Error
    extends Serializable {
        public String getId();

        public List<String> getMessages();
    }

    @JsonSerialize(as=ImmutableSnapshotResource.class)
    @JsonDeserialize(as=ImmutableSnapshotResource.class)
    @Value.Immutable
    public static interface SnapshotResource
    extends ReResource {
        public Head getHead();

        public Project getProject();

        public Map<String, Blob> getBlobs();

        public Map<String, Error> getErrors();
    }

    @JsonSerialize(as=ImmutableBlobUpdate.class)
    @JsonDeserialize(as=ImmutableBlobUpdate.class)
    @Value.Immutable
    public static interface BlobUpdate
    extends BatchMutator {
        public String getBlob();
    }

    public static interface BatchMutator
    extends Serializable {
        public String getCommit();
    }
}

