/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.SnapshotResource", generator="Immutables")
@Immutable
public final class ImmutableSnapshotResource
implements ReResource.SnapshotResource {
    private final ReResource.Head head;
    private final ReResource.Project project;
    private final ImmutableMap<String, ReResource.Blob> blobs;
    private final ImmutableMap<String, ReResource.Error> errors;

    private ImmutableSnapshotResource(ReResource.Head head, ReResource.Project project, ImmutableMap<String, ReResource.Blob> blobs, ImmutableMap<String, ReResource.Error> errors) {
        this.head = head;
        this.project = project;
        this.blobs = blobs;
        this.errors = errors;
    }

    @Override
    @JsonProperty(value="head")
    public ReResource.Head getHead() {
        return this.head;
    }

    @Override
    @JsonProperty(value="project")
    public ReResource.Project getProject() {
        return this.project;
    }

    @JsonProperty(value="blobs")
    public ImmutableMap<String, ReResource.Blob> getBlobs() {
        return this.blobs;
    }

    @JsonProperty(value="errors")
    public ImmutableMap<String, ReResource.Error> getErrors() {
        return this.errors;
    }

    public final ImmutableSnapshotResource withHead(ReResource.Head value) {
        if (this.head == value) {
            return this;
        }
        ReResource.Head newValue = Objects.requireNonNull(value, "head");
        return new ImmutableSnapshotResource(newValue, this.project, this.blobs, this.errors);
    }

    public final ImmutableSnapshotResource withProject(ReResource.Project value) {
        if (this.project == value) {
            return this;
        }
        ReResource.Project newValue = Objects.requireNonNull(value, "project");
        return new ImmutableSnapshotResource(this.head, newValue, this.blobs, this.errors);
    }

    public final ImmutableSnapshotResource withBlobs(Map<String, ? extends ReResource.Blob> entries) {
        if (this.blobs == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSnapshotResource(this.head, this.project, (ImmutableMap<String, ReResource.Blob>)newValue, this.errors);
    }

    public final ImmutableSnapshotResource withErrors(Map<String, ? extends ReResource.Error> entries) {
        if (this.errors == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSnapshotResource(this.head, this.project, this.blobs, (ImmutableMap<String, ReResource.Error>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSnapshotResource && this.equalTo((ImmutableSnapshotResource)another);
    }

    private boolean equalTo(ImmutableSnapshotResource another) {
        return this.head.equals(another.head) && this.project.equals(another.project) && this.blobs.equals(another.blobs) && this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.head.hashCode();
        h += (h << 5) + this.project.hashCode();
        h += (h << 5) + this.blobs.hashCode();
        h += (h << 5) + this.errors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SnapshotResource").omitNullValues().add("head", (Object)this.head).add("project", (Object)this.project).add("blobs", this.blobs).add("errors", this.errors).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSnapshotResource fromJson(Json json) {
        Builder builder = ImmutableSnapshotResource.builder();
        if (json.head != null) {
            builder.head(json.head);
        }
        if (json.project != null) {
            builder.project(json.project);
        }
        if (json.blobs != null) {
            builder.putAllBlobs(json.blobs);
        }
        if (json.errors != null) {
            builder.putAllErrors(json.errors);
        }
        return builder.build();
    }

    public static ImmutableSnapshotResource copyOf(ReResource.SnapshotResource instance) {
        if (instance instanceof ImmutableSnapshotResource) {
            return (ImmutableSnapshotResource)instance;
        }
        return ImmutableSnapshotResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.SnapshotResource", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HEAD = 1L;
        private static final long INIT_BIT_PROJECT = 2L;
        private long initBits = 3L;
        @Nullable
        private ReResource.Head head;
        @Nullable
        private ReResource.Project project;
        private ImmutableMap.Builder<String, ReResource.Blob> blobs = ImmutableMap.builder();
        private ImmutableMap.Builder<String, ReResource.Error> errors = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.SnapshotResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.head(instance.getHead());
            this.project(instance.getProject());
            this.putAllBlobs(instance.getBlobs());
            this.putAllErrors(instance.getErrors());
            return this;
        }

        @JsonProperty(value="head")
        @CanIgnoreReturnValue
        public final Builder head(ReResource.Head head) {
            this.head = Objects.requireNonNull(head, "head");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="project")
        @CanIgnoreReturnValue
        public final Builder project(ReResource.Project project) {
            this.project = Objects.requireNonNull(project, "project");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBlobs(String key, ReResource.Blob value) {
            this.blobs.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBlobs(Map.Entry<String, ? extends ReResource.Blob> entry) {
            this.blobs.put(entry);
            return this;
        }

        @JsonProperty(value="blobs")
        @CanIgnoreReturnValue
        public final Builder blobs(Map<String, ? extends ReResource.Blob> entries) {
            this.blobs = ImmutableMap.builder();
            return this.putAllBlobs(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllBlobs(Map<String, ? extends ReResource.Blob> entries) {
            this.blobs.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putErrors(String key, ReResource.Error value) {
            this.errors.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putErrors(Map.Entry<String, ? extends ReResource.Error> entry) {
            this.errors.put(entry);
            return this;
        }

        @JsonProperty(value="errors")
        @CanIgnoreReturnValue
        public final Builder errors(Map<String, ? extends ReResource.Error> entries) {
            this.errors = ImmutableMap.builder();
            return this.putAllErrors(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllErrors(Map<String, ? extends ReResource.Error> entries) {
            this.errors.putAll(entries);
            return this;
        }

        public ImmutableSnapshotResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSnapshotResource(this.head, this.project, (ImmutableMap<String, ReResource.Blob>)this.blobs.build(), (ImmutableMap<String, ReResource.Error>)this.errors.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("head");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("project");
            }
            return "Cannot build SnapshotResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.SnapshotResource", generator="Immutables")
    static final class Json
    implements ReResource.SnapshotResource {
        @Nullable
        ReResource.Head head;
        @Nullable
        ReResource.Project project;
        @Nullable
        Map<String, ReResource.Blob> blobs = ImmutableMap.of();
        @Nullable
        Map<String, ReResource.Error> errors = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="head")
        public void setHead(ReResource.Head head) {
            this.head = head;
        }

        @JsonProperty(value="project")
        public void setProject(ReResource.Project project) {
            this.project = project;
        }

        @JsonProperty(value="blobs")
        public void setBlobs(Map<String, ReResource.Blob> blobs) {
            this.blobs = blobs;
        }

        @JsonProperty(value="errors")
        public void setErrors(Map<String, ReResource.Error> errors) {
            this.errors = errors;
        }

        @Override
        public ReResource.Head getHead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReResource.Project getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, ReResource.Blob> getBlobs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, ReResource.Error> getErrors() {
            throw new UnsupportedOperationException();
        }
    }
}

