/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.ProjectResource", generator="Immutables")
@Immutable
public final class ImmutableProjectResource
implements ReResource.ProjectResource {
    private final ReResource.Project project;
    private final ImmutableMap<String, ReResource.Head> heads;
    private final ImmutableMap<String, ReResource.HeadState> states;

    private ImmutableProjectResource(ReResource.Project project, ImmutableMap<String, ReResource.Head> heads, ImmutableMap<String, ReResource.HeadState> states) {
        this.project = project;
        this.heads = heads;
        this.states = states;
    }

    @Override
    @JsonProperty(value="project")
    public ReResource.Project getProject() {
        return this.project;
    }

    @JsonProperty(value="heads")
    public ImmutableMap<String, ReResource.Head> getHeads() {
        return this.heads;
    }

    @JsonProperty(value="states")
    public ImmutableMap<String, ReResource.HeadState> getStates() {
        return this.states;
    }

    public final ImmutableProjectResource withProject(ReResource.Project value) {
        if (this.project == value) {
            return this;
        }
        ReResource.Project newValue = Objects.requireNonNull(value, "project");
        return new ImmutableProjectResource(newValue, this.heads, this.states);
    }

    public final ImmutableProjectResource withHeads(Map<String, ? extends ReResource.Head> entries) {
        if (this.heads == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableProjectResource(this.project, (ImmutableMap<String, ReResource.Head>)newValue, this.states);
    }

    public final ImmutableProjectResource withStates(Map<String, ? extends ReResource.HeadState> entries) {
        if (this.states == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableProjectResource(this.project, this.heads, (ImmutableMap<String, ReResource.HeadState>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProjectResource && this.equalTo((ImmutableProjectResource)another);
    }

    private boolean equalTo(ImmutableProjectResource another) {
        return this.project.equals(another.project) && this.heads.equals(another.heads) && this.states.equals(another.states);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.project.hashCode();
        h += (h << 5) + this.heads.hashCode();
        h += (h << 5) + this.states.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProjectResource").omitNullValues().add("project", (Object)this.project).add("heads", this.heads).add("states", this.states).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProjectResource fromJson(Json json) {
        Builder builder = ImmutableProjectResource.builder();
        if (json.project != null) {
            builder.project(json.project);
        }
        if (json.heads != null) {
            builder.putAllHeads(json.heads);
        }
        if (json.states != null) {
            builder.putAllStates(json.states);
        }
        return builder.build();
    }

    public static ImmutableProjectResource copyOf(ReResource.ProjectResource instance) {
        if (instance instanceof ImmutableProjectResource) {
            return (ImmutableProjectResource)instance;
        }
        return ImmutableProjectResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.ProjectResource", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROJECT = 1L;
        private long initBits = 1L;
        @Nullable
        private ReResource.Project project;
        private ImmutableMap.Builder<String, ReResource.Head> heads = ImmutableMap.builder();
        private ImmutableMap.Builder<String, ReResource.HeadState> states = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.ProjectResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.project(instance.getProject());
            this.putAllHeads(instance.getHeads());
            this.putAllStates(instance.getStates());
            return this;
        }

        @JsonProperty(value="project")
        @CanIgnoreReturnValue
        public final Builder project(ReResource.Project project) {
            this.project = Objects.requireNonNull(project, "project");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeads(String key, ReResource.Head value) {
            this.heads.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeads(Map.Entry<String, ? extends ReResource.Head> entry) {
            this.heads.put(entry);
            return this;
        }

        @JsonProperty(value="heads")
        @CanIgnoreReturnValue
        public final Builder heads(Map<String, ? extends ReResource.Head> entries) {
            this.heads = ImmutableMap.builder();
            return this.putAllHeads(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHeads(Map<String, ? extends ReResource.Head> entries) {
            this.heads.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putStates(String key, ReResource.HeadState value) {
            this.states.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putStates(Map.Entry<String, ? extends ReResource.HeadState> entry) {
            this.states.put(entry);
            return this;
        }

        @JsonProperty(value="states")
        @CanIgnoreReturnValue
        public final Builder states(Map<String, ? extends ReResource.HeadState> entries) {
            this.states = ImmutableMap.builder();
            return this.putAllStates(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllStates(Map<String, ? extends ReResource.HeadState> entries) {
            this.states.putAll(entries);
            return this;
        }

        public ImmutableProjectResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProjectResource(this.project, (ImmutableMap<String, ReResource.Head>)this.heads.build(), (ImmutableMap<String, ReResource.HeadState>)this.states.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("project");
            }
            return "Cannot build ProjectResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.ProjectResource", generator="Immutables")
    static final class Json
    implements ReResource.ProjectResource {
        @Nullable
        ReResource.Project project;
        @Nullable
        Map<String, ReResource.Head> heads = ImmutableMap.of();
        @Nullable
        Map<String, ReResource.HeadState> states = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="project")
        public void setProject(ReResource.Project project) {
            this.project = project;
        }

        @JsonProperty(value="heads")
        public void setHeads(Map<String, ReResource.Head> heads) {
            this.heads = heads;
        }

        @JsonProperty(value="states")
        public void setStates(Map<String, ReResource.HeadState> states) {
            this.states = states;
        }

        @Override
        public ReResource.Project getProject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, ReResource.Head> getHeads() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, ReResource.HeadState> getStates() {
            throw new UnsupportedOperationException();
        }
    }
}

