/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.Project", generator="Immutables")
@Immutable
public final class ImmutableProject
implements ReResource.Project {
    private final String id;
    private final String rev;
    private final String name;
    private final LocalDateTime created;

    private ImmutableProject(String id, String rev, String name, LocalDateTime created) {
        this.id = id;
        this.rev = rev;
        this.name = name;
        this.created = created;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="rev")
    public String getRev() {
        return this.rev;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="created")
    public LocalDateTime getCreated() {
        return this.created;
    }

    public final ImmutableProject withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableProject(newValue, this.rev, this.name, this.created);
    }

    public final ImmutableProject withRev(String value) {
        String newValue = Objects.requireNonNull(value, "rev");
        if (this.rev.equals(newValue)) {
            return this;
        }
        return new ImmutableProject(this.id, newValue, this.name, this.created);
    }

    public final ImmutableProject withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableProject(this.id, this.rev, newValue, this.created);
    }

    public final ImmutableProject withCreated(LocalDateTime value) {
        if (this.created == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "created");
        return new ImmutableProject(this.id, this.rev, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProject && this.equalTo((ImmutableProject)another);
    }

    private boolean equalTo(ImmutableProject another) {
        return this.id.equals(another.id) && this.rev.equals(another.rev) && this.name.equals(another.name) && this.created.equals(another.created);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.rev.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.created.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Project").omitNullValues().add("id", (Object)this.id).add("rev", (Object)this.rev).add("name", (Object)this.name).add("created", (Object)this.created).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProject fromJson(Json json) {
        Builder builder = ImmutableProject.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.rev != null) {
            builder.rev(json.rev);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.created != null) {
            builder.created(json.created);
        }
        return builder.build();
    }

    public static ImmutableProject copyOf(ReResource.Project instance) {
        if (instance instanceof ImmutableProject) {
            return (ImmutableProject)instance;
        }
        return ImmutableProject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.Project", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_REV = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_CREATED = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String rev;
        @Nullable
        private String name;
        @Nullable
        private LocalDateTime created;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.Project instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.rev(instance.getRev());
            this.name(instance.getName());
            this.created(instance.getCreated());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="rev")
        @CanIgnoreReturnValue
        public final Builder rev(String rev) {
            this.rev = Objects.requireNonNull(rev, "rev");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="created")
        @CanIgnoreReturnValue
        public final Builder created(LocalDateTime created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableProject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProject(this.id, this.rev, this.name, this.created);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rev");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("created");
            }
            return "Cannot build Project, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.Project", generator="Immutables")
    static final class Json
    implements ReResource.Project {
        @Nullable
        String id;
        @Nullable
        String rev;
        @Nullable
        String name;
        @Nullable
        LocalDateTime created;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="rev")
        public void setRev(String rev) {
            this.rev = rev;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="created")
        public void setCreated(LocalDateTime created) {
            this.created = created;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getCreated() {
            throw new UnsupportedOperationException();
        }
    }
}

