/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.HeadState", generator="Immutables")
@Immutable
public final class ImmutableHeadState
implements ReResource.HeadState {
    private final String id;
    private final String head;
    private final Long commits;
    private final ReResource.HeadStateType type;

    private ImmutableHeadState(String id, String head, Long commits, ReResource.HeadStateType type) {
        this.id = id;
        this.head = head;
        this.commits = commits;
        this.type = type;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="head")
    public String getHead() {
        return this.head;
    }

    @Override
    @JsonProperty(value="commits")
    public Long getCommits() {
        return this.commits;
    }

    @Override
    @JsonProperty(value="type")
    public ReResource.HeadStateType getType() {
        return this.type;
    }

    public final ImmutableHeadState withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableHeadState(newValue, this.head, this.commits, this.type);
    }

    public final ImmutableHeadState withHead(String value) {
        String newValue = Objects.requireNonNull(value, "head");
        if (this.head.equals(newValue)) {
            return this;
        }
        return new ImmutableHeadState(this.id, newValue, this.commits, this.type);
    }

    public final ImmutableHeadState withCommits(Long value) {
        Long newValue = Objects.requireNonNull(value, "commits");
        if (this.commits.equals(newValue)) {
            return this;
        }
        return new ImmutableHeadState(this.id, this.head, newValue, this.type);
    }

    public final ImmutableHeadState withType(ReResource.HeadStateType value) {
        if (this.type == value) {
            return this;
        }
        ReResource.HeadStateType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableHeadState(this.id, this.head, this.commits, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHeadState && this.equalTo((ImmutableHeadState)another);
    }

    private boolean equalTo(ImmutableHeadState another) {
        return this.id.equals(another.id) && this.head.equals(another.head) && this.commits.equals(another.commits) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.head.hashCode();
        h += (h << 5) + this.commits.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HeadState").omitNullValues().add("id", (Object)this.id).add("head", (Object)this.head).add("commits", (Object)this.commits).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHeadState fromJson(Json json) {
        Builder builder = ImmutableHeadState.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.head != null) {
            builder.head(json.head);
        }
        if (json.commits != null) {
            builder.commits(json.commits);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableHeadState copyOf(ReResource.HeadState instance) {
        if (instance instanceof ImmutableHeadState) {
            return (ImmutableHeadState)instance;
        }
        return ImmutableHeadState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.HeadState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_HEAD = 2L;
        private static final long INIT_BIT_COMMITS = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String head;
        @Nullable
        private Long commits;
        @Nullable
        private ReResource.HeadStateType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.HeadState instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.head(instance.getHead());
            this.commits(instance.getCommits());
            this.type(instance.getType());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="head")
        @CanIgnoreReturnValue
        public final Builder head(String head) {
            this.head = Objects.requireNonNull(head, "head");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="commits")
        @CanIgnoreReturnValue
        public final Builder commits(Long commits) {
            this.commits = Objects.requireNonNull(commits, "commits");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(ReResource.HeadStateType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableHeadState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHeadState(this.id, this.head, this.commits, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("head");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("commits");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build HeadState, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.HeadState", generator="Immutables")
    static final class Json
    implements ReResource.HeadState {
        @Nullable
        String id;
        @Nullable
        String head;
        @Nullable
        Long commits;
        @Nullable
        ReResource.HeadStateType type;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="head")
        public void setHead(String head) {
            this.head = head;
        }

        @JsonProperty(value="commits")
        public void setCommits(Long commits) {
            this.commits = commits;
        }

        @JsonProperty(value="type")
        public void setType(ReResource.HeadStateType type) {
            this.type = type;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getCommits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReResource.HeadStateType getType() {
            throw new UnsupportedOperationException();
        }
    }
}

