/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.Head", generator="Immutables")
@Immutable
public final class ImmutableHead
implements ReResource.Head {
    private final String id;
    private final String name;
    private final ReResource.Commit commit;

    private ImmutableHead(String id, String name, ReResource.Commit commit) {
        this.id = id;
        this.name = name;
        this.commit = commit;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="commit")
    public ReResource.Commit getCommit() {
        return this.commit;
    }

    public final ImmutableHead withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableHead(newValue, this.name, this.commit);
    }

    public final ImmutableHead withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableHead(this.id, newValue, this.commit);
    }

    public final ImmutableHead withCommit(ReResource.Commit value) {
        if (this.commit == value) {
            return this;
        }
        ReResource.Commit newValue = Objects.requireNonNull(value, "commit");
        return new ImmutableHead(this.id, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHead && this.equalTo((ImmutableHead)another);
    }

    private boolean equalTo(ImmutableHead another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.commit.equals(another.commit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.commit.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Head").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("commit", (Object)this.commit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHead fromJson(Json json) {
        Builder builder = ImmutableHead.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.commit != null) {
            builder.commit(json.commit);
        }
        return builder.build();
    }

    public static ImmutableHead copyOf(ReResource.Head instance) {
        if (instance instanceof ImmutableHead) {
            return (ImmutableHead)instance;
        }
        return ImmutableHead.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.Head", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_COMMIT = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private ReResource.Commit commit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.Head instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.commit(instance.getCommit());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="commit")
        @CanIgnoreReturnValue
        public final Builder commit(ReResource.Commit commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableHead build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHead(this.id, this.name, this.commit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("commit");
            }
            return "Cannot build Head, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.Head", generator="Immutables")
    static final class Json
    implements ReResource.Head {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        ReResource.Commit commit;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="commit")
        public void setCommit(ReResource.Commit commit) {
            this.commit = commit;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReResource.Commit getCommit() {
            throw new UnsupportedOperationException();
        }
    }
}

