/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.Error", generator="Immutables")
@Immutable
public final class ImmutableError
implements ReResource.Error {
    private final String id;
    private final ImmutableList<String> messages;

    private ImmutableError(String id, ImmutableList<String> messages) {
        this.id = id;
        this.messages = messages;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="messages")
    public ImmutableList<String> getMessages() {
        return this.messages;
    }

    public final ImmutableError withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableError(newValue, this.messages);
    }

    public final ImmutableError withMessages(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableError(this.id, (ImmutableList<String>)newValue);
    }

    public final ImmutableError withMessages(Iterable<String> elements) {
        if (this.messages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableError(this.id, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableError && this.equalTo((ImmutableError)another);
    }

    private boolean equalTo(ImmutableError another) {
        return this.id.equals(another.id) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Error").omitNullValues().add("id", (Object)this.id).add("messages", this.messages).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableError fromJson(Json json) {
        Builder builder = ImmutableError.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.messages != null) {
            builder.addAllMessages(json.messages);
        }
        return builder.build();
    }

    public static ImmutableError copyOf(ReResource.Error instance) {
        if (instance instanceof ImmutableError) {
            return (ImmutableError)instance;
        }
        return ImmutableError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.Error", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private ImmutableList.Builder<String> messages = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.Error instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.addAllMessages(instance.getMessages());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(String element) {
            this.messages.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(String ... elements) {
            this.messages.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="messages")
        @CanIgnoreReturnValue
        public final Builder messages(Iterable<String> elements) {
            this.messages = ImmutableList.builder();
            return this.addAllMessages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMessages(Iterable<String> elements) {
            this.messages.addAll(elements);
            return this;
        }

        public ImmutableError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableError(this.id, (ImmutableList<String>)this.messages.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Error, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.Error", generator="Immutables")
    static final class Json
    implements ReResource.Error {
        @Nullable
        String id;
        @Nullable
        List<String> messages = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="messages")
        public void setMessages(List<String> messages) {
            this.messages = messages;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getMessages() {
            throw new UnsupportedOperationException();
        }
    }
}

