/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReException.ConstraintViolation", generator="Immutables")
@Immutable
public final class ImmutableConstraintViolation
implements ReException.ConstraintViolation {
    private final String id;
    private final String rev;
    private final ReException.ConstraintType constraint;
    private final ReException.ErrorType type;

    private ImmutableConstraintViolation(String id, String rev, ReException.ConstraintType constraint, ReException.ErrorType type) {
        this.id = id;
        this.rev = rev;
        this.constraint = constraint;
        this.type = type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRev() {
        return this.rev;
    }

    @Override
    public ReException.ConstraintType getConstraint() {
        return this.constraint;
    }

    @Override
    public ReException.ErrorType getType() {
        return this.type;
    }

    public final ImmutableConstraintViolation withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableConstraintViolation(newValue, this.rev, this.constraint, this.type);
    }

    public final ImmutableConstraintViolation withRev(String value) {
        String newValue = Objects.requireNonNull(value, "rev");
        if (this.rev.equals(newValue)) {
            return this;
        }
        return new ImmutableConstraintViolation(this.id, newValue, this.constraint, this.type);
    }

    public final ImmutableConstraintViolation withConstraint(ReException.ConstraintType value) {
        if (this.constraint == value) {
            return this;
        }
        ReException.ConstraintType newValue = Objects.requireNonNull(value, "constraint");
        if (this.constraint.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableConstraintViolation(this.id, this.rev, newValue, this.type);
    }

    public final ImmutableConstraintViolation withType(ReException.ErrorType value) {
        if (this.type == value) {
            return this;
        }
        ReException.ErrorType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableConstraintViolation(this.id, this.rev, this.constraint, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConstraintViolation && this.equalTo((ImmutableConstraintViolation)another);
    }

    private boolean equalTo(ImmutableConstraintViolation another) {
        return this.id.equals(another.id) && this.rev.equals(another.rev) && this.constraint.equals((Object)another.constraint) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.rev.hashCode();
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConstraintViolation").omitNullValues().add("id", (Object)this.id).add("rev", (Object)this.rev).add("constraint", (Object)this.constraint).add("type", (Object)this.type).toString();
    }

    public static ImmutableConstraintViolation copyOf(ReException.ConstraintViolation instance) {
        if (instance instanceof ImmutableConstraintViolation) {
            return (ImmutableConstraintViolation)instance;
        }
        return ImmutableConstraintViolation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReException.ConstraintViolation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_REV = 2L;
        private static final long INIT_BIT_CONSTRAINT = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String rev;
        @Nullable
        private ReException.ConstraintType constraint;
        @Nullable
        private ReException.ErrorType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReException.ConstraintViolation instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.rev(instance.getRev());
            this.constraint(instance.getConstraint());
            this.type(instance.getType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rev(String rev) {
            this.rev = Objects.requireNonNull(rev, "rev");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constraint(ReException.ConstraintType constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(ReException.ErrorType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableConstraintViolation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConstraintViolation(this.id, this.rev, this.constraint, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rev");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ConstraintViolation, some of required attributes are not set " + attributes;
        }
    }
}

