/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.Commit", generator="Immutables")
@Immutable
public final class ImmutableCommit
implements ReResource.Commit {
    private final String id;
    private final String author;
    private final LocalDateTime dateTime;

    private ImmutableCommit(String id, String author, LocalDateTime dateTime) {
        this.id = id;
        this.author = author;
        this.dateTime = dateTime;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="author")
    public String getAuthor() {
        return this.author;
    }

    @Override
    @JsonProperty(value="dateTime")
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public final ImmutableCommit withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableCommit(newValue, this.author, this.dateTime);
    }

    public final ImmutableCommit withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableCommit(this.id, newValue, this.dateTime);
    }

    public final ImmutableCommit withDateTime(LocalDateTime value) {
        if (this.dateTime == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "dateTime");
        return new ImmutableCommit(this.id, this.author, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommit && this.equalTo((ImmutableCommit)another);
    }

    private boolean equalTo(ImmutableCommit another) {
        return this.id.equals(another.id) && this.author.equals(another.author) && this.dateTime.equals(another.dateTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.dateTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Commit").omitNullValues().add("id", (Object)this.id).add("author", (Object)this.author).add("dateTime", (Object)this.dateTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommit fromJson(Json json) {
        Builder builder = ImmutableCommit.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.dateTime != null) {
            builder.dateTime(json.dateTime);
        }
        return builder.build();
    }

    public static ImmutableCommit copyOf(ReResource.Commit instance) {
        if (instance instanceof ImmutableCommit) {
            return (ImmutableCommit)instance;
        }
        return ImmutableCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.Commit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_AUTHOR = 2L;
        private static final long INIT_BIT_DATE_TIME = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String author;
        @Nullable
        private LocalDateTime dateTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.Commit instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.author(instance.getAuthor());
            this.dateTime(instance.getDateTime());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="author")
        @CanIgnoreReturnValue
        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="dateTime")
        @CanIgnoreReturnValue
        public final Builder dateTime(LocalDateTime dateTime) {
            this.dateTime = Objects.requireNonNull(dateTime, "dateTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCommit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommit(this.id, this.author, this.dateTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dateTime");
            }
            return "Cannot build Commit, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.Commit", generator="Immutables")
    static final class Json
    implements ReResource.Commit {
        @Nullable
        String id;
        @Nullable
        String author;
        @Nullable
        LocalDateTime dateTime;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="author")
        public void setAuthor(String author) {
            this.author = author;
        }

        @JsonProperty(value="dateTime")
        public void setDateTime(LocalDateTime dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getDateTime() {
            throw new UnsupportedOperationException();
        }
    }
}

