/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.BlobUpdate", generator="Immutables")
@Immutable
public final class ImmutableBlobUpdate
implements ReResource.BlobUpdate {
    private final String commit;
    private final String blob;

    private ImmutableBlobUpdate(String commit, String blob) {
        this.commit = commit;
        this.blob = blob;
    }

    @Override
    @JsonProperty(value="commit")
    public String getCommit() {
        return this.commit;
    }

    @Override
    @JsonProperty(value="blob")
    public String getBlob() {
        return this.blob;
    }

    public final ImmutableBlobUpdate withCommit(String value) {
        String newValue = Objects.requireNonNull(value, "commit");
        if (this.commit.equals(newValue)) {
            return this;
        }
        return new ImmutableBlobUpdate(newValue, this.blob);
    }

    public final ImmutableBlobUpdate withBlob(String value) {
        String newValue = Objects.requireNonNull(value, "blob");
        if (this.blob.equals(newValue)) {
            return this;
        }
        return new ImmutableBlobUpdate(this.commit, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlobUpdate && this.equalTo((ImmutableBlobUpdate)another);
    }

    private boolean equalTo(ImmutableBlobUpdate another) {
        return this.commit.equals(another.commit) && this.blob.equals(another.blob);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.blob.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BlobUpdate").omitNullValues().add("commit", (Object)this.commit).add("blob", (Object)this.blob).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBlobUpdate fromJson(Json json) {
        Builder builder = ImmutableBlobUpdate.builder();
        if (json.commit != null) {
            builder.commit(json.commit);
        }
        if (json.blob != null) {
            builder.blob(json.blob);
        }
        return builder.build();
    }

    public static ImmutableBlobUpdate copyOf(ReResource.BlobUpdate instance) {
        if (instance instanceof ImmutableBlobUpdate) {
            return (ImmutableBlobUpdate)instance;
        }
        return ImmutableBlobUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.BlobUpdate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMIT = 1L;
        private static final long INIT_BIT_BLOB = 2L;
        private long initBits = 3L;
        @Nullable
        private String commit;
        @Nullable
        private String blob;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.BatchMutator instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.BlobUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReResource.BatchMutator instance;
            if (object instanceof ReResource.BatchMutator) {
                instance = (ReResource.BatchMutator)object;
                this.commit(instance.getCommit());
            }
            if (object instanceof ReResource.BlobUpdate) {
                instance = (ReResource.BlobUpdate)object;
                this.blob(instance.getBlob());
            }
        }

        @JsonProperty(value="commit")
        @CanIgnoreReturnValue
        public final Builder commit(String commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="blob")
        @CanIgnoreReturnValue
        public final Builder blob(String blob) {
            this.blob = Objects.requireNonNull(blob, "blob");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBlobUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBlobUpdate(this.commit, this.blob);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("blob");
            }
            return "Cannot build BlobUpdate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.BlobUpdate", generator="Immutables")
    static final class Json
    implements ReResource.BlobUpdate {
        @Nullable
        String commit;
        @Nullable
        String blob;

        Json() {
        }

        @JsonProperty(value="commit")
        public void setCommit(String commit) {
            this.commit = commit;
        }

        @JsonProperty(value="blob")
        public void setBlob(String blob) {
            this.blob = blob;
        }

        @Override
        public String getCommit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBlob() {
            throw new UnsupportedOperationException();
        }
    }
}

