/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.resource.editor.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.resource.editor.api.ReResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReResource.Blob", generator="Immutables")
@Immutable
public final class ImmutableBlob
implements ReResource.Blob {
    private final String id;
    private final String name;
    private final String src;
    private final ImmutableMap<String, Serializable> ast;

    private ImmutableBlob(String id, String name, String src, ImmutableMap<String, Serializable> ast) {
        this.id = id;
        this.name = name;
        this.src = src;
        this.ast = ast;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="src")
    public String getSrc() {
        return this.src;
    }

    @JsonProperty(value="ast")
    public ImmutableMap<String, Serializable> getAst() {
        return this.ast;
    }

    public final ImmutableBlob withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableBlob(newValue, this.name, this.src, this.ast);
    }

    public final ImmutableBlob withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableBlob(this.id, newValue, this.src, this.ast);
    }

    public final ImmutableBlob withSrc(String value) {
        String newValue = Objects.requireNonNull(value, "src");
        if (this.src.equals(newValue)) {
            return this;
        }
        return new ImmutableBlob(this.id, this.name, newValue, this.ast);
    }

    public final ImmutableBlob withAst(Map<String, ? extends Serializable> entries) {
        if (this.ast == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableBlob(this.id, this.name, this.src, (ImmutableMap<String, Serializable>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlob && this.equalTo((ImmutableBlob)another);
    }

    private boolean equalTo(ImmutableBlob another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.src.equals(another.src) && this.ast.equals(another.ast);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.src.hashCode();
        h += (h << 5) + this.ast.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Blob").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("src", (Object)this.src).add("ast", this.ast).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBlob fromJson(Json json) {
        Builder builder = ImmutableBlob.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.src != null) {
            builder.src(json.src);
        }
        if (json.ast != null) {
            builder.putAllAst(json.ast);
        }
        return builder.build();
    }

    public static ImmutableBlob copyOf(ReResource.Blob instance) {
        if (instance instanceof ImmutableBlob) {
            return (ImmutableBlob)instance;
        }
        return ImmutableBlob.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReResource.Blob", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_SRC = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String src;
        private ImmutableMap.Builder<String, Serializable> ast = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReResource.Blob instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.src(instance.getSrc());
            this.putAllAst(instance.getAst());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="src")
        @CanIgnoreReturnValue
        public final Builder src(String src) {
            this.src = Objects.requireNonNull(src, "src");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAst(String key, Serializable value) {
            this.ast.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAst(Map.Entry<String, ? extends Serializable> entry) {
            this.ast.put(entry);
            return this;
        }

        @JsonProperty(value="ast")
        @CanIgnoreReturnValue
        public final Builder ast(Map<String, ? extends Serializable> entries) {
            this.ast = ImmutableMap.builder();
            return this.putAllAst(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAst(Map<String, ? extends Serializable> entries) {
            this.ast.putAll(entries);
            return this;
        }

        public ImmutableBlob build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBlob(this.id, this.name, this.src, (ImmutableMap<String, Serializable>)this.ast.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("src");
            }
            return "Cannot build Blob, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReResource.Blob", generator="Immutables")
    static final class Json
    implements ReResource.Blob {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String src;
        @Nullable
        Map<String, Serializable> ast = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="src")
        public void setSrc(String src) {
            this.src = src;
        }

        @JsonProperty(value="ast")
        public void setAst(Map<String, Serializable> ast) {
            this.ast = ast;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSrc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Serializable> getAst() {
            throw new UnsupportedOperationException();
        }
    }
}

