package io.resys.thena.docdb.spi.diff;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DiffVisitor.DiffCommitMatch}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiffCommitMatch.builder()}.
 */
@Generated(from = "DiffVisitor.DiffCommitMatch", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDiffCommitMatch
    implements DiffVisitor.DiffCommitMatch {
  private final CommitHistory src;
  private final CommitHistory target;

  private ImmutableDiffCommitMatch(CommitHistory src, CommitHistory target) {
    this.src = src;
    this.target = target;
  }

  /**
   * @return The value of the {@code src} attribute
   */
  @Override
  public CommitHistory getSrc() {
    return src;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @Override
  public CommitHistory getTarget() {
    return target;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiffVisitor.DiffCommitMatch#getSrc() src} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for src
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffCommitMatch withSrc(CommitHistory value) {
    if (this.src == value) return this;
    CommitHistory newValue = Objects.requireNonNull(value, "src");
    return new ImmutableDiffCommitMatch(newValue, this.target);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiffVisitor.DiffCommitMatch#getTarget() target} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffCommitMatch withTarget(CommitHistory value) {
    if (this.target == value) return this;
    CommitHistory newValue = Objects.requireNonNull(value, "target");
    return new ImmutableDiffCommitMatch(this.src, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiffCommitMatch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiffCommitMatch
        && equalTo((ImmutableDiffCommitMatch) another);
  }

  private boolean equalTo(ImmutableDiffCommitMatch another) {
    return src.equals(another.src)
        && target.equals(another.target);
  }

  /**
   * Computes a hash code from attributes: {@code src}, {@code target}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + src.hashCode();
    h += (h << 5) + target.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DiffCommitMatch} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DiffCommitMatch")
        .omitNullValues()
        .add("src", src)
        .add("target", target)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DiffVisitor.DiffCommitMatch} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DiffCommitMatch instance
   */
  public static ImmutableDiffCommitMatch copyOf(DiffVisitor.DiffCommitMatch instance) {
    if (instance instanceof ImmutableDiffCommitMatch) {
      return (ImmutableDiffCommitMatch) instance;
    }
    return ImmutableDiffCommitMatch.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiffCommitMatch ImmutableDiffCommitMatch}.
   * <pre>
   * ImmutableDiffCommitMatch.builder()
   *    .src(io.resys.thena.docdb.spi.diff.CommitHistory) // required {@link DiffVisitor.DiffCommitMatch#getSrc() src}
   *    .target(io.resys.thena.docdb.spi.diff.CommitHistory) // required {@link DiffVisitor.DiffCommitMatch#getTarget() target}
   *    .build();
   * </pre>
   * @return A new ImmutableDiffCommitMatch builder
   */
  public static ImmutableDiffCommitMatch.Builder builder() {
    return new ImmutableDiffCommitMatch.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDiffCommitMatch ImmutableDiffCommitMatch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DiffVisitor.DiffCommitMatch", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SRC = 0x1L;
    private static final long INIT_BIT_TARGET = 0x2L;
    private long initBits = 0x3L;

    private @Nullable CommitHistory src;
    private @Nullable CommitHistory target;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DiffCommitMatch} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DiffVisitor.DiffCommitMatch instance) {
      Objects.requireNonNull(instance, "instance");
      src(instance.getSrc());
      target(instance.getTarget());
      return this;
    }

    /**
     * Initializes the value for the {@link DiffVisitor.DiffCommitMatch#getSrc() src} attribute.
     * @param src The value for src 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder src(CommitHistory src) {
      this.src = Objects.requireNonNull(src, "src");
      initBits &= ~INIT_BIT_SRC;
      return this;
    }

    /**
     * Initializes the value for the {@link DiffVisitor.DiffCommitMatch#getTarget() target} attribute.
     * @param target The value for target 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder target(CommitHistory target) {
      this.target = Objects.requireNonNull(target, "target");
      initBits &= ~INIT_BIT_TARGET;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiffCommitMatch ImmutableDiffCommitMatch}.
     * @return An immutable instance of DiffCommitMatch
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiffCommitMatch build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDiffCommitMatch(src, target);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SRC) != 0) attributes.add("src");
      if ((initBits & INIT_BIT_TARGET) != 0) attributes.add("target");
      return "Cannot build DiffCommitMatch, some of required attributes are not set " + attributes;
    }
  }
}
