package io.resys.thena.docdb.spi;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClientInsertBuilder.InsertResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInsertResult.builder()}.
 */
@Generated(from = "ClientInsertBuilder.InsertResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInsertResult implements ClientInsertBuilder.InsertResult {
  private final boolean duplicate;

  private ImmutableInsertResult(boolean duplicate) {
    this.duplicate = duplicate;
  }

  /**
   * @return The value of the {@code duplicate} attribute
   */
  @Override
  public boolean getDuplicate() {
    return duplicate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientInsertBuilder.InsertResult#getDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInsertResult withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableInsertResult(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInsertResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInsertResult
        && equalTo((ImmutableInsertResult) another);
  }

  private boolean equalTo(ImmutableInsertResult another) {
    return duplicate == another.duplicate;
  }

  /**
   * Computes a hash code from attributes: {@code duplicate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(duplicate);
    return h;
  }

  /**
   * Prints the immutable value {@code InsertResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InsertResult")
        .omitNullValues()
        .add("duplicate", duplicate)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ClientInsertBuilder.InsertResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InsertResult instance
   */
  public static ImmutableInsertResult copyOf(ClientInsertBuilder.InsertResult instance) {
    if (instance instanceof ImmutableInsertResult) {
      return (ImmutableInsertResult) instance;
    }
    return ImmutableInsertResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInsertResult ImmutableInsertResult}.
   * <pre>
   * ImmutableInsertResult.builder()
   *    .duplicate(boolean) // required {@link ClientInsertBuilder.InsertResult#getDuplicate() duplicate}
   *    .build();
   * </pre>
   * @return A new ImmutableInsertResult builder
   */
  public static ImmutableInsertResult.Builder builder() {
    return new ImmutableInsertResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInsertResult ImmutableInsertResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClientInsertBuilder.InsertResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DUPLICATE = 0x1L;
    private long initBits = 0x1L;

    private boolean duplicate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InsertResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ClientInsertBuilder.InsertResult instance) {
      Objects.requireNonNull(instance, "instance");
      duplicate(instance.getDuplicate());
      return this;
    }

    /**
     * Initializes the value for the {@link ClientInsertBuilder.InsertResult#getDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder duplicate(boolean duplicate) {
      this.duplicate = duplicate;
      initBits &= ~INIT_BIT_DUPLICATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInsertResult ImmutableInsertResult}.
     * @return An immutable instance of InsertResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInsertResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInsertResult(duplicate);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DUPLICATE) != 0) attributes.add("duplicate");
      return "Cannot build InsertResult, some of required attributes are not set " + attributes;
    }
  }
}
