package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Diff.DivergenceRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDivergenceRef.builder()}.
 */
@Generated(from = "Diff.DivergenceRef", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDivergenceRef implements Diff.DivergenceRef {
  private final ImmutableList<String> refs;
  private final ImmutableList<String> tags;
  private final Integer commits;
  private final Objects.Commit commit;

  private ImmutableDivergenceRef(
      ImmutableList<String> refs,
      ImmutableList<String> tags,
      Integer commits,
      Objects.Commit commit) {
    this.refs = refs;
    this.tags = tags;
    this.commits = commits;
    this.commit = commit;
  }

  /**
   * @return The value of the {@code refs} attribute
   */
  @Override
  public ImmutableList<String> getRefs() {
    return refs;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @Override
  public ImmutableList<String> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code commits} attribute
   */
  @Override
  public Integer getCommits() {
    return commits;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public Objects.Commit getCommit() {
    return commit;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Diff.DivergenceRef#getRefs() refs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDivergenceRef withRefs(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDivergenceRef(newValue, this.tags, this.commits, this.commit);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Diff.DivergenceRef#getRefs() refs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of refs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDivergenceRef withRefs(Iterable<String> elements) {
    if (this.refs == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDivergenceRef(newValue, this.tags, this.commits, this.commit);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Diff.DivergenceRef#getTags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDivergenceRef withTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDivergenceRef(this.refs, newValue, this.commits, this.commit);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Diff.DivergenceRef#getTags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDivergenceRef withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDivergenceRef(this.refs, newValue, this.commits, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.DivergenceRef#getCommits() commits} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commits
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDivergenceRef withCommits(Integer value) {
    Integer newValue = java.util.Objects.requireNonNull(value, "commits");
    if (this.commits.equals(newValue)) return this;
    return new ImmutableDivergenceRef(this.refs, this.tags, newValue, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.DivergenceRef#getCommit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDivergenceRef withCommit(Objects.Commit value) {
    if (this.commit == value) return this;
    Objects.Commit newValue = java.util.Objects.requireNonNull(value, "commit");
    return new ImmutableDivergenceRef(this.refs, this.tags, this.commits, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDivergenceRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDivergenceRef
        && equalTo((ImmutableDivergenceRef) another);
  }

  private boolean equalTo(ImmutableDivergenceRef another) {
    return refs.equals(another.refs)
        && tags.equals(another.tags)
        && commits.equals(another.commits)
        && commit.equals(another.commit);
  }

  /**
   * Computes a hash code from attributes: {@code refs}, {@code tags}, {@code commits}, {@code commit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + refs.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + commits.hashCode();
    h += (h << 5) + commit.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DivergenceRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DivergenceRef")
        .omitNullValues()
        .add("refs", refs)
        .add("tags", tags)
        .add("commits", commits)
        .add("commit", commit)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Diff.DivergenceRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DivergenceRef instance
   */
  public static ImmutableDivergenceRef copyOf(Diff.DivergenceRef instance) {
    if (instance instanceof ImmutableDivergenceRef) {
      return (ImmutableDivergenceRef) instance;
    }
    return ImmutableDivergenceRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDivergenceRef ImmutableDivergenceRef}.
   * <pre>
   * ImmutableDivergenceRef.builder()
   *    .addRefs|addAllRefs(String) // {@link Diff.DivergenceRef#getRefs() refs} elements
   *    .addTags|addAllTags(String) // {@link Diff.DivergenceRef#getTags() tags} elements
   *    .commits(Integer) // required {@link Diff.DivergenceRef#getCommits() commits}
   *    .commit(io.resys.thena.docdb.api.models.Objects.Commit) // required {@link Diff.DivergenceRef#getCommit() commit}
   *    .build();
   * </pre>
   * @return A new ImmutableDivergenceRef builder
   */
  public static ImmutableDivergenceRef.Builder builder() {
    return new ImmutableDivergenceRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDivergenceRef ImmutableDivergenceRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Diff.DivergenceRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COMMITS = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private long initBits = 0x3L;

    private ImmutableList.Builder<String> refs = ImmutableList.builder();
    private ImmutableList.Builder<String> tags = ImmutableList.builder();
    private @Nullable Integer commits;
    private @Nullable Objects.Commit commit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DivergenceRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Diff.DivergenceRef instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      addAllRefs(instance.getRefs());
      addAllTags(instance.getTags());
      commits(instance.getCommits());
      commit(instance.getCommit());
      return this;
    }

    /**
     * Adds one element to {@link Diff.DivergenceRef#getRefs() refs} list.
     * @param element A refs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRefs(String element) {
      this.refs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Diff.DivergenceRef#getRefs() refs} list.
     * @param elements An array of refs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRefs(String... elements) {
      this.refs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Diff.DivergenceRef#getRefs() refs} list.
     * @param elements An iterable of refs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder refs(Iterable<String> elements) {
      this.refs = ImmutableList.builder();
      return addAllRefs(elements);
    }

    /**
     * Adds elements to {@link Diff.DivergenceRef#getRefs() refs} list.
     * @param elements An iterable of refs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRefs(Iterable<String> elements) {
      this.refs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Diff.DivergenceRef#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String element) {
      this.tags.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Diff.DivergenceRef#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String... elements) {
      this.tags.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Diff.DivergenceRef#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tags(Iterable<String> elements) {
      this.tags = ImmutableList.builder();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link Diff.DivergenceRef#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTags(Iterable<String> elements) {
      this.tags.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.DivergenceRef#getCommits() commits} attribute.
     * @param commits The value for commits 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commits(Integer commits) {
      this.commits = java.util.Objects.requireNonNull(commits, "commits");
      initBits &= ~INIT_BIT_COMMITS;
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.DivergenceRef#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(Objects.Commit commit) {
      this.commit = java.util.Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDivergenceRef ImmutableDivergenceRef}.
     * @return An immutable instance of DivergenceRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDivergenceRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDivergenceRef(refs.build(), tags.build(), commits, commit);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COMMITS) != 0) attributes.add("commits");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      return "Cannot build DivergenceRef, some of required attributes are not set " + attributes;
    }
  }
}
