package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Diff.Divergence}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDivergence.builder()}.
 */
@Generated(from = "Diff.Divergence", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDivergence implements Diff.Divergence {
  private final Diff.DivergenceType type;
  private final Diff.DivergenceRef head;
  private final Diff.DivergenceRef main;
  private final ImmutableList<Diff.DiffAction> actions;

  private ImmutableDivergence(
      Diff.DivergenceType type,
      Diff.DivergenceRef head,
      Diff.DivergenceRef main,
      ImmutableList<Diff.DiffAction> actions) {
    this.type = type;
    this.head = head;
    this.main = main;
    this.actions = actions;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public Diff.DivergenceType getType() {
    return type;
  }

  /**
   * @return The value of the {@code head} attribute
   */
  @Override
  public Diff.DivergenceRef getHead() {
    return head;
  }

  /**
   * @return The value of the {@code main} attribute
   */
  @Override
  public Diff.DivergenceRef getMain() {
    return main;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @Override
  public ImmutableList<Diff.DiffAction> getActions() {
    return actions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.Divergence#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDivergence withType(Diff.DivergenceType value) {
    if (this.type == value) return this;
    Diff.DivergenceType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableDivergence(newValue, this.head, this.main, this.actions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.Divergence#getHead() head} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for head
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDivergence withHead(Diff.DivergenceRef value) {
    if (this.head == value) return this;
    Diff.DivergenceRef newValue = Objects.requireNonNull(value, "head");
    return new ImmutableDivergence(this.type, newValue, this.main, this.actions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.Divergence#getMain() main} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for main
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDivergence withMain(Diff.DivergenceRef value) {
    if (this.main == value) return this;
    Diff.DivergenceRef newValue = Objects.requireNonNull(value, "main");
    return new ImmutableDivergence(this.type, this.head, newValue, this.actions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Diff.Divergence#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDivergence withActions(Diff.DiffAction... elements) {
    ImmutableList<Diff.DiffAction> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDivergence(this.type, this.head, this.main, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Diff.Divergence#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDivergence withActions(Iterable<? extends Diff.DiffAction> elements) {
    if (this.actions == elements) return this;
    ImmutableList<Diff.DiffAction> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDivergence(this.type, this.head, this.main, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDivergence} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDivergence
        && equalTo((ImmutableDivergence) another);
  }

  private boolean equalTo(ImmutableDivergence another) {
    return type.equals(another.type)
        && head.equals(another.head)
        && main.equals(another.main)
        && actions.equals(another.actions);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code head}, {@code main}, {@code actions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + head.hashCode();
    h += (h << 5) + main.hashCode();
    h += (h << 5) + actions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Divergence} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Divergence")
        .omitNullValues()
        .add("type", type)
        .add("head", head)
        .add("main", main)
        .add("actions", actions)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Diff.Divergence} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Divergence instance
   */
  public static ImmutableDivergence copyOf(Diff.Divergence instance) {
    if (instance instanceof ImmutableDivergence) {
      return (ImmutableDivergence) instance;
    }
    return ImmutableDivergence.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDivergence ImmutableDivergence}.
   * <pre>
   * ImmutableDivergence.builder()
   *    .type(io.resys.thena.docdb.api.models.Diff.DivergenceType) // required {@link Diff.Divergence#getType() type}
   *    .head(io.resys.thena.docdb.api.models.Diff.DivergenceRef) // required {@link Diff.Divergence#getHead() head}
   *    .main(io.resys.thena.docdb.api.models.Diff.DivergenceRef) // required {@link Diff.Divergence#getMain() main}
   *    .addActions|addAllActions(io.resys.thena.docdb.api.models.Diff.DiffAction) // {@link Diff.Divergence#getActions() actions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDivergence builder
   */
  public static ImmutableDivergence.Builder builder() {
    return new ImmutableDivergence.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDivergence ImmutableDivergence}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Diff.Divergence", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_HEAD = 0x2L;
    private static final long INIT_BIT_MAIN = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Diff.DivergenceType type;
    private @Nullable Diff.DivergenceRef head;
    private @Nullable Diff.DivergenceRef main;
    private ImmutableList.Builder<Diff.DiffAction> actions = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Divergence} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Diff.Divergence instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      head(instance.getHead());
      main(instance.getMain());
      addAllActions(instance.getActions());
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.Divergence#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(Diff.DivergenceType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.Divergence#getHead() head} attribute.
     * @param head The value for head 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder head(Diff.DivergenceRef head) {
      this.head = Objects.requireNonNull(head, "head");
      initBits &= ~INIT_BIT_HEAD;
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.Divergence#getMain() main} attribute.
     * @param main The value for main 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder main(Diff.DivergenceRef main) {
      this.main = Objects.requireNonNull(main, "main");
      initBits &= ~INIT_BIT_MAIN;
      return this;
    }

    /**
     * Adds one element to {@link Diff.Divergence#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addActions(Diff.DiffAction element) {
      this.actions.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Diff.Divergence#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addActions(Diff.DiffAction... elements) {
      this.actions.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Diff.Divergence#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder actions(Iterable<? extends Diff.DiffAction> elements) {
      this.actions = ImmutableList.builder();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link Diff.Divergence#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllActions(Iterable<? extends Diff.DiffAction> elements) {
      this.actions.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDivergence ImmutableDivergence}.
     * @return An immutable instance of Divergence
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDivergence build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDivergence(type, head, main, actions.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_HEAD) != 0) attributes.add("head");
      if ((initBits & INIT_BIT_MAIN) != 0) attributes.add("main");
      return "Cannot build Divergence, some of required attributes are not set " + attributes;
    }
  }
}
