package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Diff}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiff.builder()}.
 */
@Generated(from = "Diff", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDiff implements Diff {
  private final Repo repo;
  private final ImmutableList<Diff.Divergence> divergences;

  private ImmutableDiff(
      Repo repo,
      ImmutableList<Diff.Divergence> divergences) {
    this.repo = repo;
    this.divergences = divergences;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code divergences} attribute
   */
  @Override
  public ImmutableList<Diff.Divergence> getDivergences() {
    return divergences;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiff withRepo(Repo value) {
    if (this.repo == value) return this;
    Repo newValue = Objects.requireNonNull(value, "repo");
    return new ImmutableDiff(newValue, this.divergences);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Diff#getDivergences() divergences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDiff withDivergences(Diff.Divergence... elements) {
    ImmutableList<Diff.Divergence> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDiff(this.repo, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Diff#getDivergences() divergences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of divergences elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDiff withDivergences(Iterable<? extends Diff.Divergence> elements) {
    if (this.divergences == elements) return this;
    ImmutableList<Diff.Divergence> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDiff(this.repo, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiff} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiff
        && equalTo((ImmutableDiff) another);
  }

  private boolean equalTo(ImmutableDiff another) {
    return repo.equals(another.repo)
        && divergences.equals(another.divergences);
  }

  /**
   * Computes a hash code from attributes: {@code repo}, {@code divergences}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + repo.hashCode();
    h += (h << 5) + divergences.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Diff} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Diff")
        .omitNullValues()
        .add("repo", repo)
        .add("divergences", divergences)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Diff} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Diff instance
   */
  public static ImmutableDiff copyOf(Diff instance) {
    if (instance instanceof ImmutableDiff) {
      return (ImmutableDiff) instance;
    }
    return ImmutableDiff.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiff ImmutableDiff}.
   * <pre>
   * ImmutableDiff.builder()
   *    .repo(io.resys.thena.docdb.api.models.Repo) // required {@link Diff#getRepo() repo}
   *    .addDivergences|addAllDivergences(io.resys.thena.docdb.api.models.Diff.Divergence) // {@link Diff#getDivergences() divergences} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDiff builder
   */
  public static ImmutableDiff.Builder builder() {
    return new ImmutableDiff.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDiff ImmutableDiff}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Diff", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REPO = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Repo repo;
    private ImmutableList.Builder<Diff.Divergence> divergences = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Diff} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Diff instance) {
      Objects.requireNonNull(instance, "instance");
      repo(instance.getRepo());
      addAllDivergences(instance.getDivergences());
      return this;
    }

    /**
     * Initializes the value for the {@link Diff#getRepo() repo} attribute.
     * @param repo The value for repo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(Repo repo) {
      this.repo = Objects.requireNonNull(repo, "repo");
      initBits &= ~INIT_BIT_REPO;
      return this;
    }

    /**
     * Adds one element to {@link Diff#getDivergences() divergences} list.
     * @param element A divergences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDivergences(Diff.Divergence element) {
      this.divergences.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Diff#getDivergences() divergences} list.
     * @param elements An array of divergences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDivergences(Diff.Divergence... elements) {
      this.divergences.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Diff#getDivergences() divergences} list.
     * @param elements An iterable of divergences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder divergences(Iterable<? extends Diff.Divergence> elements) {
      this.divergences = ImmutableList.builder();
      return addAllDivergences(elements);
    }

    /**
     * Adds elements to {@link Diff#getDivergences() divergences} list.
     * @param elements An iterable of divergences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDivergences(Iterable<? extends Diff.Divergence> elements) {
      this.divergences.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiff ImmutableDiff}.
     * @return An immutable instance of Diff
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiff build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDiff(repo, divergences.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REPO) != 0) attributes.add("repo");
      return "Cannot build Diff, some of required attributes are not set " + attributes;
    }
  }
}
