package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Objects.Commit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommit.builder()}.
 */
@Generated(from = "Objects.Commit", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommit implements Objects.Commit {
  private final String id;
  private final String author;
  private final LocalDateTime dateTime;
  private final String message;
  private final @Nullable String parent;
  private final @Nullable String merge;
  private final String tree;

  private ImmutableCommit(
      String id,
      String author,
      LocalDateTime dateTime,
      String message,
      @Nullable String parent,
      @Nullable String merge,
      String tree) {
    this.id = id;
    this.author = author;
    this.dateTime = dateTime;
    this.message = message;
    this.parent = parent;
    this.merge = merge;
    this.tree = tree;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @Override
  public String getAuthor() {
    return author;
  }

  /**
   * @return The value of the {@code dateTime} attribute
   */
  @Override
  public LocalDateTime getDateTime() {
    return dateTime;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @Override
  public Optional<String> getParent() {
    return Optional.ofNullable(parent);
  }

  /**
   * @return The value of the {@code merge} attribute
   */
  @Override
  public Optional<String> getMerge() {
    return Optional.ofNullable(merge);
  }

  /**
   * @return The value of the {@code tree} attribute
   */
  @Override
  public String getTree() {
    return tree;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Commit#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withId(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableCommit(newValue, this.author, this.dateTime, this.message, this.parent, this.merge, this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Commit#getAuthor() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withAuthor(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "author");
    if (this.author.equals(newValue)) return this;
    return new ImmutableCommit(this.id, newValue, this.dateTime, this.message, this.parent, this.merge, this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Commit#getDateTime() dateTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dateTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withDateTime(LocalDateTime value) {
    if (this.dateTime == value) return this;
    LocalDateTime newValue = java.util.Objects.requireNonNull(value, "dateTime");
    return new ImmutableCommit(this.id, this.author, newValue, this.message, this.parent, this.merge, this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Commit#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withMessage(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableCommit(this.id, this.author, this.dateTime, newValue, this.parent, this.merge, this.tree);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Objects.Commit#getParent() parent} attribute.
   * @param value The value for parent
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withParent(String value) {
    @Nullable String newValue = java.util.Objects.requireNonNull(value, "parent");
    if (java.util.Objects.equals(this.parent, newValue)) return this;
    return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, newValue, this.merge, this.tree);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Objects.Commit#getParent() parent} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for parent
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withParent(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (java.util.Objects.equals(this.parent, value)) return this;
    return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, value, this.merge, this.tree);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Objects.Commit#getMerge() merge} attribute.
   * @param value The value for merge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withMerge(String value) {
    @Nullable String newValue = java.util.Objects.requireNonNull(value, "merge");
    if (java.util.Objects.equals(this.merge, newValue)) return this;
    return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, this.parent, newValue, this.tree);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Objects.Commit#getMerge() merge} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for merge
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommit withMerge(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (java.util.Objects.equals(this.merge, value)) return this;
    return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, this.parent, value, this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Commit#getTree() tree} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommit withTree(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "tree");
    if (this.tree.equals(newValue)) return this;
    return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, this.parent, this.merge, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommit
        && equalTo((ImmutableCommit) another);
  }

  private boolean equalTo(ImmutableCommit another) {
    return id.equals(another.id)
        && author.equals(another.author)
        && dateTime.equals(another.dateTime)
        && message.equals(another.message)
        && java.util.Objects.equals(parent, another.parent)
        && java.util.Objects.equals(merge, another.merge)
        && tree.equals(another.tree);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code author}, {@code dateTime}, {@code message}, {@code parent}, {@code merge}, {@code tree}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + author.hashCode();
    h += (h << 5) + dateTime.hashCode();
    h += (h << 5) + message.hashCode();
    h += (h << 5) + java.util.Objects.hashCode(parent);
    h += (h << 5) + java.util.Objects.hashCode(merge);
    h += (h << 5) + tree.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Commit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Commit")
        .omitNullValues()
        .add("id", id)
        .add("author", author)
        .add("dateTime", dateTime)
        .add("message", message)
        .add("parent", parent)
        .add("merge", merge)
        .add("tree", tree)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Objects.Commit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Commit instance
   */
  public static ImmutableCommit copyOf(Objects.Commit instance) {
    if (instance instanceof ImmutableCommit) {
      return (ImmutableCommit) instance;
    }
    return ImmutableCommit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommit ImmutableCommit}.
   * <pre>
   * ImmutableCommit.builder()
   *    .id(String) // required {@link Objects.Commit#getId() id}
   *    .author(String) // required {@link Objects.Commit#getAuthor() author}
   *    .dateTime(java.time.LocalDateTime) // required {@link Objects.Commit#getDateTime() dateTime}
   *    .message(String) // required {@link Objects.Commit#getMessage() message}
   *    .parent(String) // optional {@link Objects.Commit#getParent() parent}
   *    .merge(String) // optional {@link Objects.Commit#getMerge() merge}
   *    .tree(String) // required {@link Objects.Commit#getTree() tree}
   *    .build();
   * </pre>
   * @return A new ImmutableCommit builder
   */
  public static ImmutableCommit.Builder builder() {
    return new ImmutableCommit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommit ImmutableCommit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Objects.Commit", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_AUTHOR = 0x2L;
    private static final long INIT_BIT_DATE_TIME = 0x4L;
    private static final long INIT_BIT_MESSAGE = 0x8L;
    private static final long INIT_BIT_TREE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String author;
    private @Nullable LocalDateTime dateTime;
    private @Nullable String message;
    private @Nullable String parent;
    private @Nullable String merge;
    private @Nullable String tree;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.IsObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.IsObject instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.Commit} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.Commit instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Objects.IsObject) {
        Objects.IsObject instance = (Objects.IsObject) object;
        id(instance.getId());
      }
      if (object instanceof Objects.Commit) {
        Objects.Commit instance = (Objects.Commit) object;
        dateTime(instance.getDateTime());
        tree(instance.getTree());
        Optional<String> parentOptional = instance.getParent();
        if (parentOptional.isPresent()) {
          parent(parentOptional);
        }
        message(instance.getMessage());
        author(instance.getAuthor());
        Optional<String> mergeOptional = instance.getMerge();
        if (mergeOptional.isPresent()) {
          merge(mergeOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link Objects.Commit#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = java.util.Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Commit#getAuthor() author} attribute.
     * @param author The value for author 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder author(String author) {
      this.author = java.util.Objects.requireNonNull(author, "author");
      initBits &= ~INIT_BIT_AUTHOR;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Commit#getDateTime() dateTime} attribute.
     * @param dateTime The value for dateTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dateTime(LocalDateTime dateTime) {
      this.dateTime = java.util.Objects.requireNonNull(dateTime, "dateTime");
      initBits &= ~INIT_BIT_DATE_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Commit#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder message(String message) {
      this.message = java.util.Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the optional value {@link Objects.Commit#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(String parent) {
      this.parent = java.util.Objects.requireNonNull(parent, "parent");
      return this;
    }

    /**
     * Initializes the optional value {@link Objects.Commit#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(Optional<String> parent) {
      this.parent = parent.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Objects.Commit#getMerge() merge} to merge.
     * @param merge The value for merge
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder merge(String merge) {
      this.merge = java.util.Objects.requireNonNull(merge, "merge");
      return this;
    }

    /**
     * Initializes the optional value {@link Objects.Commit#getMerge() merge} to merge.
     * @param merge The value for merge
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder merge(Optional<String> merge) {
      this.merge = merge.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Commit#getTree() tree} attribute.
     * @param tree The value for tree 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tree(String tree) {
      this.tree = java.util.Objects.requireNonNull(tree, "tree");
      initBits &= ~INIT_BIT_TREE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommit ImmutableCommit}.
     * @return An immutable instance of Commit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommit build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommit(id, author, dateTime, message, parent, merge, tree);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_AUTHOR) != 0) attributes.add("author");
      if ((initBits & INIT_BIT_DATE_TIME) != 0) attributes.add("dateTime");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_TREE) != 0) attributes.add("tree");
      return "Cannot build Commit, some of required attributes are not set " + attributes;
    }
  }
}
