package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DiffActions.DiffResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiffResult.builder()}.
 */
@Generated(from = "DiffActions.DiffResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDiffResult<T>
    implements DiffActions.DiffResult<T> {
  private final @Nullable Repo repo;
  private final @Nullable T objects;
  private final DiffActions.DiffStatus status;
  private final ImmutableList<Message> messages;

  private ImmutableDiffResult(
      @Nullable Repo repo,
      @Nullable T objects,
      DiffActions.DiffStatus status,
      ImmutableList<Message> messages) {
    this.repo = repo;
    this.objects = objects;
    this.status = status;
    this.messages = messages;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public @Nullable Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code objects} attribute
   */
  @Override
  public @Nullable T getObjects() {
    return objects;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @Override
  public DiffActions.DiffStatus getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @Override
  public ImmutableList<Message> getMessages() {
    return messages;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiffActions.DiffResult#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffResult<T> withRepo(@Nullable Repo value) {
    if (this.repo == value) return this;
    return new ImmutableDiffResult<>(value, this.objects, this.status, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiffActions.DiffResult#getObjects() objects} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for objects (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffResult<T> withObjects(@Nullable T value) {
    if (this.objects == value) return this;
    return new ImmutableDiffResult<>(this.repo, value, this.status, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DiffActions.DiffResult#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffResult<T> withStatus(DiffActions.DiffStatus value) {
    if (this.status == value) return this;
    DiffActions.DiffStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableDiffResult<>(this.repo, this.objects, newValue, this.messages);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DiffActions.DiffResult#getMessages() messages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDiffResult<T> withMessages(Message... elements) {
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDiffResult<>(this.repo, this.objects, this.status, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DiffActions.DiffResult#getMessages() messages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDiffResult<T> withMessages(Iterable<? extends Message> elements) {
    if (this.messages == elements) return this;
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDiffResult<>(this.repo, this.objects, this.status, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiffResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiffResult<?>
        && equalTo((ImmutableDiffResult<?>) another);
  }

  private boolean equalTo(ImmutableDiffResult<?> another) {
    return Objects.equals(repo, another.repo)
        && Objects.equals(objects, another.objects)
        && status.equals(another.status)
        && messages.equals(another.messages);
  }

  /**
   * Computes a hash code from attributes: {@code repo}, {@code objects}, {@code status}, {@code messages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repo);
    h += (h << 5) + Objects.hashCode(objects);
    h += (h << 5) + status.hashCode();
    h += (h << 5) + messages.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DiffResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DiffResult")
        .omitNullValues()
        .add("repo", repo)
        .add("objects", objects)
        .add("status", status)
        .add("messages", messages)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DiffActions.DiffResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable DiffResult instance
   */
  public static <T> ImmutableDiffResult<T> copyOf(DiffActions.DiffResult<T> instance) {
    if (instance instanceof ImmutableDiffResult<?>) {
      return (ImmutableDiffResult<T>) instance;
    }
    return ImmutableDiffResult.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiffResult ImmutableDiffResult}.
   * <pre>
   * ImmutableDiffResult.&amp;lt;T&amp;gt;builder()
   *    .repo(io.resys.thena.docdb.api.models.Repo | null) // nullable {@link DiffActions.DiffResult#getRepo() repo}
   *    .objects(T | null) // nullable {@link DiffActions.DiffResult#getObjects() objects}
   *    .status(io.resys.thena.docdb.api.actions.DiffActions.DiffStatus) // required {@link DiffActions.DiffResult#getStatus() status}
   *    .addMessages|addAllMessages(io.resys.thena.docdb.api.models.Message) // {@link DiffActions.DiffResult#getMessages() messages} elements
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableDiffResult builder
   */
  public static <T> ImmutableDiffResult.Builder<T> builder() {
    return new ImmutableDiffResult.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableDiffResult ImmutableDiffResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DiffActions.DiffResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_STATUS = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Repo repo;
    private @Nullable T objects;
    private @Nullable DiffActions.DiffStatus status;
    private ImmutableList.Builder<Message> messages = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DiffResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(DiffActions.DiffResult<T> instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Repo repoValue = instance.getRepo();
      if (repoValue != null) {
        repo(repoValue);
      }
      @Nullable T objectsValue = instance.getObjects();
      if (objectsValue != null) {
        objects(objectsValue);
      }
      status(instance.getStatus());
      addAllMessages(instance.getMessages());
      return this;
    }

    /**
     * Initializes the value for the {@link DiffActions.DiffResult#getRepo() repo} attribute.
     * @param repo The value for repo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> repo(@Nullable Repo repo) {
      this.repo = repo;
      return this;
    }

    /**
     * Initializes the value for the {@link DiffActions.DiffResult#getObjects() objects} attribute.
     * @param objects The value for objects (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> objects(@Nullable T objects) {
      this.objects = objects;
      return this;
    }

    /**
     * Initializes the value for the {@link DiffActions.DiffResult#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> status(DiffActions.DiffStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Adds one element to {@link DiffActions.DiffResult#getMessages() messages} list.
     * @param element A messages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addMessages(Message element) {
      this.messages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DiffActions.DiffResult#getMessages() messages} list.
     * @param elements An array of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addMessages(Message... elements) {
      this.messages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DiffActions.DiffResult#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> messages(Iterable<? extends Message> elements) {
      this.messages = ImmutableList.builder();
      return addAllMessages(elements);
    }

    /**
     * Adds elements to {@link DiffActions.DiffResult#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addAllMessages(Iterable<? extends Message> elements) {
      this.messages.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiffResult ImmutableDiffResult}.
     * @return An immutable instance of DiffResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiffResult<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDiffResult<>(repo, objects, status, messages.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build DiffResult, some of required attributes are not set " + attributes;
    }
  }
}
