package io.resys.thena.docdb.spi.objects;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BlobStateBuilderDefault.BlobAndTree}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlobAndTree.builder()}.
 */
@Generated(from = "BlobStateBuilderDefault.BlobAndTree", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBlobAndTree
    implements BlobStateBuilderDefault.BlobAndTree {
  private final ImmutableList<Objects.Blob> blob;
  private final Objects.Tree tree;

  private ImmutableBlobAndTree(
      ImmutableList<Objects.Blob> blob,
      Objects.Tree tree) {
    this.blob = blob;
    this.tree = tree;
  }

  /**
   * @return The value of the {@code blob} attribute
   */
  @Override
  public ImmutableList<Objects.Blob> getBlob() {
    return blob;
  }

  /**
   * @return The value of the {@code tree} attribute
   */
  @Override
  public Objects.Tree getTree() {
    return tree;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlobStateBuilderDefault.BlobAndTree#getBlob() blob}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlobAndTree withBlob(Objects.Blob... elements) {
    ImmutableList<Objects.Blob> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBlobAndTree(newValue, this.tree);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlobStateBuilderDefault.BlobAndTree#getBlob() blob}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blob elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlobAndTree withBlob(Iterable<? extends Objects.Blob> elements) {
    if (this.blob == elements) return this;
    ImmutableList<Objects.Blob> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBlobAndTree(newValue, this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlobStateBuilderDefault.BlobAndTree#getTree() tree} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobAndTree withTree(Objects.Tree value) {
    if (this.tree == value) return this;
    Objects.Tree newValue = java.util.Objects.requireNonNull(value, "tree");
    return new ImmutableBlobAndTree(this.blob, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlobAndTree} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlobAndTree
        && equalTo((ImmutableBlobAndTree) another);
  }

  private boolean equalTo(ImmutableBlobAndTree another) {
    return blob.equals(another.blob)
        && tree.equals(another.tree);
  }

  /**
   * Computes a hash code from attributes: {@code blob}, {@code tree}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + blob.hashCode();
    h += (h << 5) + tree.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BlobAndTree} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BlobAndTree")
        .omitNullValues()
        .add("blob", blob)
        .add("tree", tree)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link BlobStateBuilderDefault.BlobAndTree} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlobAndTree instance
   */
  public static ImmutableBlobAndTree copyOf(BlobStateBuilderDefault.BlobAndTree instance) {
    if (instance instanceof ImmutableBlobAndTree) {
      return (ImmutableBlobAndTree) instance;
    }
    return ImmutableBlobAndTree.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlobAndTree ImmutableBlobAndTree}.
   * <pre>
   * ImmutableBlobAndTree.builder()
   *    .addBlob|addAllBlob(io.resys.thena.docdb.api.models.Objects.Blob) // {@link BlobStateBuilderDefault.BlobAndTree#getBlob() blob} elements
   *    .tree(io.resys.thena.docdb.api.models.Objects.Tree) // required {@link BlobStateBuilderDefault.BlobAndTree#getTree() tree}
   *    .build();
   * </pre>
   * @return A new ImmutableBlobAndTree builder
   */
  public static ImmutableBlobAndTree.Builder builder() {
    return new ImmutableBlobAndTree.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlobAndTree ImmutableBlobAndTree}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BlobStateBuilderDefault.BlobAndTree", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TREE = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Objects.Blob> blob = ImmutableList.builder();
    private @Nullable Objects.Tree tree;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BlobAndTree} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BlobStateBuilderDefault.BlobAndTree instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      addAllBlob(instance.getBlob());
      tree(instance.getTree());
      return this;
    }

    /**
     * Adds one element to {@link BlobStateBuilderDefault.BlobAndTree#getBlob() blob} list.
     * @param element A blob element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBlob(Objects.Blob element) {
      this.blob.add(element);
      return this;
    }

    /**
     * Adds elements to {@link BlobStateBuilderDefault.BlobAndTree#getBlob() blob} list.
     * @param elements An array of blob elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBlob(Objects.Blob... elements) {
      this.blob.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlobStateBuilderDefault.BlobAndTree#getBlob() blob} list.
     * @param elements An iterable of blob elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blob(Iterable<? extends Objects.Blob> elements) {
      this.blob = ImmutableList.builder();
      return addAllBlob(elements);
    }

    /**
     * Adds elements to {@link BlobStateBuilderDefault.BlobAndTree#getBlob() blob} list.
     * @param elements An iterable of blob elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBlob(Iterable<? extends Objects.Blob> elements) {
      this.blob.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link BlobStateBuilderDefault.BlobAndTree#getTree() tree} attribute.
     * @param tree The value for tree 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tree(Objects.Tree tree) {
      this.tree = java.util.Objects.requireNonNull(tree, "tree");
      initBits &= ~INIT_BIT_TREE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlobAndTree ImmutableBlobAndTree}.
     * @return An immutable instance of BlobAndTree
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlobAndTree build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBlobAndTree(blob.build(), tree);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TREE) != 0) attributes.add("tree");
      return "Cannot build BlobAndTree, some of required attributes are not set " + attributes;
    }
  }
}
