package io.resys.thena.docdb.spi.commits;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitVisitor.RedundentCommitTree}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRedundentCommitTree.builder()}.
 */
@Generated(from = "CommitVisitor.RedundentCommitTree", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableRedundentCommitTree
    implements CommitVisitor.RedundentCommitTree {
  private final boolean isEmpty;
  private final ImmutableMap<String, Objects.TreeValue> treeValues;
  private final ImmutableMap<String, Objects.Blob> blobs;
  private final String log;

  private ImmutableRedundentCommitTree(
      boolean isEmpty,
      ImmutableMap<String, Objects.TreeValue> treeValues,
      ImmutableMap<String, Objects.Blob> blobs,
      String log) {
    this.isEmpty = isEmpty;
    this.treeValues = treeValues;
    this.blobs = blobs;
    this.log = log;
  }

  /**
   * @return The value of the {@code isEmpty} attribute
   */
  @Override
  public boolean isEmpty() {
    return isEmpty;
  }

  /**
   * @return The value of the {@code treeValues} attribute
   */
  @Override
  public ImmutableMap<String, Objects.TreeValue> getTreeValues() {
    return treeValues;
  }

  /**
   * @return The value of the {@code blobs} attribute
   */
  @Override
  public ImmutableMap<String, Objects.Blob> getBlobs() {
    return blobs;
  }

  /**
   * @return The value of the {@code log} attribute
   */
  @Override
  public String getLog() {
    return log;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.RedundentCommitTree#isEmpty() isEmpty} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isEmpty
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedundentCommitTree withIsEmpty(boolean value) {
    if (this.isEmpty == value) return this;
    return new ImmutableRedundentCommitTree(value, this.treeValues, this.blobs, this.log);
  }

  /**
   * Copy the current immutable object by replacing the {@link CommitVisitor.RedundentCommitTree#getTreeValues() treeValues} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the treeValues map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRedundentCommitTree withTreeValues(Map<String, ? extends Objects.TreeValue> entries) {
    if (this.treeValues == entries) return this;
    ImmutableMap<String, Objects.TreeValue> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableRedundentCommitTree(this.isEmpty, newValue, this.blobs, this.log);
  }

  /**
   * Copy the current immutable object by replacing the {@link CommitVisitor.RedundentCommitTree#getBlobs() blobs} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the blobs map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRedundentCommitTree withBlobs(Map<String, ? extends Objects.Blob> entries) {
    if (this.blobs == entries) return this;
    ImmutableMap<String, Objects.Blob> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableRedundentCommitTree(this.isEmpty, this.treeValues, newValue, this.log);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.RedundentCommitTree#getLog() log} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for log
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedundentCommitTree withLog(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "log");
    if (this.log.equals(newValue)) return this;
    return new ImmutableRedundentCommitTree(this.isEmpty, this.treeValues, this.blobs, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRedundentCommitTree} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRedundentCommitTree
        && equalTo((ImmutableRedundentCommitTree) another);
  }

  private boolean equalTo(ImmutableRedundentCommitTree another) {
    return isEmpty == another.isEmpty
        && treeValues.equals(another.treeValues)
        && blobs.equals(another.blobs)
        && log.equals(another.log);
  }

  /**
   * Computes a hash code from attributes: {@code isEmpty}, {@code treeValues}, {@code blobs}, {@code log}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(isEmpty);
    h += (h << 5) + treeValues.hashCode();
    h += (h << 5) + blobs.hashCode();
    h += (h << 5) + log.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RedundentCommitTree} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RedundentCommitTree")
        .omitNullValues()
        .add("isEmpty", isEmpty)
        .add("treeValues", treeValues)
        .add("blobs", blobs)
        .add("log", log)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CommitVisitor.RedundentCommitTree} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RedundentCommitTree instance
   */
  public static ImmutableRedundentCommitTree copyOf(CommitVisitor.RedundentCommitTree instance) {
    if (instance instanceof ImmutableRedundentCommitTree) {
      return (ImmutableRedundentCommitTree) instance;
    }
    return ImmutableRedundentCommitTree.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRedundentCommitTree ImmutableRedundentCommitTree}.
   * <pre>
   * ImmutableRedundentCommitTree.builder()
   *    .isEmpty(boolean) // required {@link CommitVisitor.RedundentCommitTree#isEmpty() isEmpty}
   *    .putTreeValues|putAllTreeValues(String =&gt; io.resys.thena.docdb.api.models.Objects.TreeValue) // {@link CommitVisitor.RedundentCommitTree#getTreeValues() treeValues} mappings
   *    .putBlobs|putAllBlobs(String =&gt; io.resys.thena.docdb.api.models.Objects.Blob) // {@link CommitVisitor.RedundentCommitTree#getBlobs() blobs} mappings
   *    .log(String) // required {@link CommitVisitor.RedundentCommitTree#getLog() log}
   *    .build();
   * </pre>
   * @return A new ImmutableRedundentCommitTree builder
   */
  public static ImmutableRedundentCommitTree.Builder builder() {
    return new ImmutableRedundentCommitTree.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRedundentCommitTree ImmutableRedundentCommitTree}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitVisitor.RedundentCommitTree", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IS_EMPTY = 0x1L;
    private static final long INIT_BIT_LOG = 0x2L;
    private long initBits = 0x3L;

    private boolean isEmpty;
    private ImmutableMap.Builder<String, Objects.TreeValue> treeValues = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Objects.Blob> blobs = ImmutableMap.builder();
    private @Nullable String log;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RedundentCommitTree} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitVisitor.RedundentCommitTree instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      isEmpty(instance.isEmpty());
      putAllTreeValues(instance.getTreeValues());
      putAllBlobs(instance.getBlobs());
      log(instance.getLog());
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.RedundentCommitTree#isEmpty() isEmpty} attribute.
     * @param isEmpty The value for isEmpty 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isEmpty(boolean isEmpty) {
      this.isEmpty = isEmpty;
      initBits &= ~INIT_BIT_IS_EMPTY;
      return this;
    }

    /**
     * Put one entry to the {@link CommitVisitor.RedundentCommitTree#getTreeValues() treeValues} map.
     * @param key The key in the treeValues map
     * @param value The associated value in the treeValues map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTreeValues(String key, Objects.TreeValue value) {
      this.treeValues.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CommitVisitor.RedundentCommitTree#getTreeValues() treeValues} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTreeValues(Map.Entry<String, ? extends Objects.TreeValue> entry) {
      this.treeValues.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CommitVisitor.RedundentCommitTree#getTreeValues() treeValues} map. Nulls are not permitted
     * @param entries The entries that will be added to the treeValues map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder treeValues(Map<String, ? extends Objects.TreeValue> entries) {
      this.treeValues = ImmutableMap.builder();
      return putAllTreeValues(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CommitVisitor.RedundentCommitTree#getTreeValues() treeValues} map. Nulls are not permitted
     * @param entries The entries that will be added to the treeValues map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTreeValues(Map<String, ? extends Objects.TreeValue> entries) {
      this.treeValues.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link CommitVisitor.RedundentCommitTree#getBlobs() blobs} map.
     * @param key The key in the blobs map
     * @param value The associated value in the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBlobs(String key, Objects.Blob value) {
      this.blobs.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CommitVisitor.RedundentCommitTree#getBlobs() blobs} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBlobs(Map.Entry<String, ? extends Objects.Blob> entry) {
      this.blobs.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CommitVisitor.RedundentCommitTree#getBlobs() blobs} map. Nulls are not permitted
     * @param entries The entries that will be added to the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobs(Map<String, ? extends Objects.Blob> entries) {
      this.blobs = ImmutableMap.builder();
      return putAllBlobs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CommitVisitor.RedundentCommitTree#getBlobs() blobs} map. Nulls are not permitted
     * @param entries The entries that will be added to the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllBlobs(Map<String, ? extends Objects.Blob> entries) {
      this.blobs.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.RedundentCommitTree#getLog() log} attribute.
     * @param log The value for log 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder log(String log) {
      this.log = java.util.Objects.requireNonNull(log, "log");
      initBits &= ~INIT_BIT_LOG;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRedundentCommitTree ImmutableRedundentCommitTree}.
     * @return An immutable instance of RedundentCommitTree
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRedundentCommitTree build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRedundentCommitTree(isEmpty, treeValues.build(), blobs.build(), log);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IS_EMPTY) != 0) attributes.add("isEmpty");
      if ((initBits & INIT_BIT_LOG) != 0) attributes.add("log");
      return "Cannot build RedundentCommitTree, some of required attributes are not set " + attributes;
    }
  }
}
