package io.resys.thena.docdb.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClientCollections}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableClientCollections.builder()}.
 */
@Generated(from = "ClientCollections", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableClientCollections extends ClientCollections {
  private final String db;
  private final String repos;
  private final String refs;
  private final String tags;
  private final String blobs;
  private final String trees;
  private final String treeItems;
  private final String commits;

  private ImmutableClientCollections(
      String db,
      String repos,
      String refs,
      String tags,
      String blobs,
      String trees,
      String treeItems,
      String commits) {
    this.db = db;
    this.repos = repos;
    this.refs = refs;
    this.tags = tags;
    this.blobs = blobs;
    this.trees = trees;
    this.treeItems = treeItems;
    this.commits = commits;
  }

  /**
   * @return The value of the {@code db} attribute
   */
  @Override
  public String getDb() {
    return db;
  }

  /**
   * @return The value of the {@code repos} attribute
   */
  @Override
  public String getRepos() {
    return repos;
  }

  /**
   * @return The value of the {@code refs} attribute
   */
  @Override
  public String getRefs() {
    return refs;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @Override
  public String getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code blobs} attribute
   */
  @Override
  public String getBlobs() {
    return blobs;
  }

  /**
   * @return The value of the {@code trees} attribute
   */
  @Override
  public String getTrees() {
    return trees;
  }

  /**
   * @return The value of the {@code treeItems} attribute
   */
  @Override
  public String getTreeItems() {
    return treeItems;
  }

  /**
   * @return The value of the {@code commits} attribute
   */
  @Override
  public String getCommits() {
    return commits;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientCollections#getDb() db} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for db
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClientCollections withDb(String value) {
    String newValue = Objects.requireNonNull(value, "db");
    if (this.db.equals(newValue)) return this;
    return new ImmutableClientCollections(
        newValue,
        this.repos,
        this.refs,
        this.tags,
        this.blobs,
        this.trees,
        this.treeItems,
        this.commits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientCollections#getRepos() repos} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repos
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClientCollections withRepos(String value) {
    String newValue = Objects.requireNonNull(value, "repos");
    if (this.repos.equals(newValue)) return this;
    return new ImmutableClientCollections(this.db, newValue, this.refs, this.tags, this.blobs, this.trees, this.treeItems, this.commits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientCollections#getRefs() refs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClientCollections withRefs(String value) {
    String newValue = Objects.requireNonNull(value, "refs");
    if (this.refs.equals(newValue)) return this;
    return new ImmutableClientCollections(this.db, this.repos, newValue, this.tags, this.blobs, this.trees, this.treeItems, this.commits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientCollections#getTags() tags} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tags
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClientCollections withTags(String value) {
    String newValue = Objects.requireNonNull(value, "tags");
    if (this.tags.equals(newValue)) return this;
    return new ImmutableClientCollections(this.db, this.repos, this.refs, newValue, this.blobs, this.trees, this.treeItems, this.commits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientCollections#getBlobs() blobs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blobs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClientCollections withBlobs(String value) {
    String newValue = Objects.requireNonNull(value, "blobs");
    if (this.blobs.equals(newValue)) return this;
    return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, newValue, this.trees, this.treeItems, this.commits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientCollections#getTrees() trees} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for trees
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClientCollections withTrees(String value) {
    String newValue = Objects.requireNonNull(value, "trees");
    if (this.trees.equals(newValue)) return this;
    return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, this.blobs, newValue, this.treeItems, this.commits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientCollections#getTreeItems() treeItems} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treeItems
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClientCollections withTreeItems(String value) {
    String newValue = Objects.requireNonNull(value, "treeItems");
    if (this.treeItems.equals(newValue)) return this;
    return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, this.blobs, this.trees, newValue, this.commits);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientCollections#getCommits() commits} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commits
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClientCollections withCommits(String value) {
    String newValue = Objects.requireNonNull(value, "commits");
    if (this.commits.equals(newValue)) return this;
    return new ImmutableClientCollections(this.db, this.repos, this.refs, this.tags, this.blobs, this.trees, this.treeItems, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableClientCollections} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableClientCollections
        && equalTo((ImmutableClientCollections) another);
  }

  private boolean equalTo(ImmutableClientCollections another) {
    return db.equals(another.db)
        && repos.equals(another.repos)
        && refs.equals(another.refs)
        && tags.equals(another.tags)
        && blobs.equals(another.blobs)
        && trees.equals(another.trees)
        && treeItems.equals(another.treeItems)
        && commits.equals(another.commits);
  }

  /**
   * Computes a hash code from attributes: {@code db}, {@code repos}, {@code refs}, {@code tags}, {@code blobs}, {@code trees}, {@code treeItems}, {@code commits}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + db.hashCode();
    h += (h << 5) + repos.hashCode();
    h += (h << 5) + refs.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + blobs.hashCode();
    h += (h << 5) + trees.hashCode();
    h += (h << 5) + treeItems.hashCode();
    h += (h << 5) + commits.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ClientCollections} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ClientCollections")
        .omitNullValues()
        .add("db", db)
        .add("repos", repos)
        .add("refs", refs)
        .add("tags", tags)
        .add("blobs", blobs)
        .add("trees", trees)
        .add("treeItems", treeItems)
        .add("commits", commits)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ClientCollections} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ClientCollections instance
   */
  public static ImmutableClientCollections copyOf(ClientCollections instance) {
    if (instance instanceof ImmutableClientCollections) {
      return (ImmutableClientCollections) instance;
    }
    return ImmutableClientCollections.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableClientCollections ImmutableClientCollections}.
   * <pre>
   * ImmutableClientCollections.builder()
   *    .db(String) // required {@link ClientCollections#getDb() db}
   *    .repos(String) // required {@link ClientCollections#getRepos() repos}
   *    .refs(String) // required {@link ClientCollections#getRefs() refs}
   *    .tags(String) // required {@link ClientCollections#getTags() tags}
   *    .blobs(String) // required {@link ClientCollections#getBlobs() blobs}
   *    .trees(String) // required {@link ClientCollections#getTrees() trees}
   *    .treeItems(String) // required {@link ClientCollections#getTreeItems() treeItems}
   *    .commits(String) // required {@link ClientCollections#getCommits() commits}
   *    .build();
   * </pre>
   * @return A new ImmutableClientCollections builder
   */
  public static ImmutableClientCollections.Builder builder() {
    return new ImmutableClientCollections.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableClientCollections ImmutableClientCollections}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClientCollections", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DB = 0x1L;
    private static final long INIT_BIT_REPOS = 0x2L;
    private static final long INIT_BIT_REFS = 0x4L;
    private static final long INIT_BIT_TAGS = 0x8L;
    private static final long INIT_BIT_BLOBS = 0x10L;
    private static final long INIT_BIT_TREES = 0x20L;
    private static final long INIT_BIT_TREE_ITEMS = 0x40L;
    private static final long INIT_BIT_COMMITS = 0x80L;
    private long initBits = 0xffL;

    private @Nullable String db;
    private @Nullable String repos;
    private @Nullable String refs;
    private @Nullable String tags;
    private @Nullable String blobs;
    private @Nullable String trees;
    private @Nullable String treeItems;
    private @Nullable String commits;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClientCollections} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ClientCollections instance) {
      Objects.requireNonNull(instance, "instance");
      db(instance.getDb());
      repos(instance.getRepos());
      refs(instance.getRefs());
      tags(instance.getTags());
      blobs(instance.getBlobs());
      trees(instance.getTrees());
      treeItems(instance.getTreeItems());
      commits(instance.getCommits());
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCollections#getDb() db} attribute.
     * @param db The value for db 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder db(String db) {
      this.db = Objects.requireNonNull(db, "db");
      initBits &= ~INIT_BIT_DB;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCollections#getRepos() repos} attribute.
     * @param repos The value for repos 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repos(String repos) {
      this.repos = Objects.requireNonNull(repos, "repos");
      initBits &= ~INIT_BIT_REPOS;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCollections#getRefs() refs} attribute.
     * @param refs The value for refs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder refs(String refs) {
      this.refs = Objects.requireNonNull(refs, "refs");
      initBits &= ~INIT_BIT_REFS;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCollections#getTags() tags} attribute.
     * @param tags The value for tags 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tags(String tags) {
      this.tags = Objects.requireNonNull(tags, "tags");
      initBits &= ~INIT_BIT_TAGS;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCollections#getBlobs() blobs} attribute.
     * @param blobs The value for blobs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobs(String blobs) {
      this.blobs = Objects.requireNonNull(blobs, "blobs");
      initBits &= ~INIT_BIT_BLOBS;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCollections#getTrees() trees} attribute.
     * @param trees The value for trees 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder trees(String trees) {
      this.trees = Objects.requireNonNull(trees, "trees");
      initBits &= ~INIT_BIT_TREES;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCollections#getTreeItems() treeItems} attribute.
     * @param treeItems The value for treeItems 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder treeItems(String treeItems) {
      this.treeItems = Objects.requireNonNull(treeItems, "treeItems");
      initBits &= ~INIT_BIT_TREE_ITEMS;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientCollections#getCommits() commits} attribute.
     * @param commits The value for commits 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commits(String commits) {
      this.commits = Objects.requireNonNull(commits, "commits");
      initBits &= ~INIT_BIT_COMMITS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableClientCollections ImmutableClientCollections}.
     * @return An immutable instance of ClientCollections
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableClientCollections build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableClientCollections(db, repos, refs, tags, blobs, trees, treeItems, commits);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DB) != 0) attributes.add("db");
      if ((initBits & INIT_BIT_REPOS) != 0) attributes.add("repos");
      if ((initBits & INIT_BIT_REFS) != 0) attributes.add("refs");
      if ((initBits & INIT_BIT_TAGS) != 0) attributes.add("tags");
      if ((initBits & INIT_BIT_BLOBS) != 0) attributes.add("blobs");
      if ((initBits & INIT_BIT_TREES) != 0) attributes.add("trees");
      if ((initBits & INIT_BIT_TREE_ITEMS) != 0) attributes.add("treeItems");
      if ((initBits & INIT_BIT_COMMITS) != 0) attributes.add("commits");
      return "Cannot build ClientCollections, some of required attributes are not set " + attributes;
    }
  }
}
