package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Objects.Tree}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTree.builder()}.
 */
@Generated(from = "Objects.Tree", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTree implements Objects.Tree {
  private final String id;
  private final ImmutableMap<String, Objects.TreeValue> values;

  private ImmutableTree(
      String id,
      ImmutableMap<String, Objects.TreeValue> values) {
    this.id = id;
    this.values = values;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  public ImmutableMap<String, Objects.TreeValue> getValues() {
    return values;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Tree#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTree withId(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableTree(newValue, this.values);
  }

  /**
   * Copy the current immutable object by replacing the {@link Objects.Tree#getValues() values} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the values map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTree withValues(Map<String, ? extends Objects.TreeValue> entries) {
    if (this.values == entries) return this;
    ImmutableMap<String, Objects.TreeValue> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableTree(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTree} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTree
        && equalTo((ImmutableTree) another);
  }

  private boolean equalTo(ImmutableTree another) {
    return id.equals(another.id)
        && values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Tree} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Tree")
        .omitNullValues()
        .add("id", id)
        .add("values", values)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Objects.Tree} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tree instance
   */
  public static ImmutableTree copyOf(Objects.Tree instance) {
    if (instance instanceof ImmutableTree) {
      return (ImmutableTree) instance;
    }
    return ImmutableTree.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTree ImmutableTree}.
   * <pre>
   * ImmutableTree.builder()
   *    .id(String) // required {@link Objects.Tree#getId() id}
   *    .putValues|putAllValues(String =&gt; io.resys.thena.docdb.api.models.Objects.TreeValue) // {@link Objects.Tree#getValues() values} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableTree builder
   */
  public static ImmutableTree.Builder builder() {
    return new ImmutableTree.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTree ImmutableTree}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Objects.Tree", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private ImmutableMap.Builder<String, Objects.TreeValue> values = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.Tree} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.Tree instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.IsObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.IsObject instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Objects.Tree) {
        Objects.Tree instance = (Objects.Tree) object;
        putAllValues(instance.getValues());
      }
      if (object instanceof Objects.IsObject) {
        Objects.IsObject instance = (Objects.IsObject) object;
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link Objects.Tree#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = java.util.Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link Objects.Tree#getValues() values} map.
     * @param key The key in the values map
     * @param value The associated value in the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValues(String key, Objects.TreeValue value) {
      this.values.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Objects.Tree#getValues() values} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValues(Map.Entry<String, ? extends Objects.TreeValue> entry) {
      this.values.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Objects.Tree#getValues() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder values(Map<String, ? extends Objects.TreeValue> entries) {
      this.values = ImmutableMap.builder();
      return putAllValues(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Objects.Tree#getValues() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllValues(Map<String, ? extends Objects.TreeValue> entries) {
      this.values.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTree ImmutableTree}.
     * @return An immutable instance of Tree
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTree build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTree(id, values.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Tree, some of required attributes are not set " + attributes;
    }
  }
}
