package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Objects.Blob}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlob.builder()}.
 */
@Generated(from = "Objects.Blob", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBlob implements Objects.Blob {
  private final String id;
  private final String value;

  private ImmutableBlob(String id, String value) {
    this.id = id;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Blob#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withId(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableBlob(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Blob#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlob withValue(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableBlob(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlob} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlob
        && equalTo((ImmutableBlob) another);
  }

  private boolean equalTo(ImmutableBlob another) {
    return id.equals(another.id)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Blob} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Blob")
        .omitNullValues()
        .add("id", id)
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Objects.Blob} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Blob instance
   */
  public static ImmutableBlob copyOf(Objects.Blob instance) {
    if (instance instanceof ImmutableBlob) {
      return (ImmutableBlob) instance;
    }
    return ImmutableBlob.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlob ImmutableBlob}.
   * <pre>
   * ImmutableBlob.builder()
   *    .id(String) // required {@link Objects.Blob#getId() id}
   *    .value(String) // required {@link Objects.Blob#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableBlob builder
   */
  public static ImmutableBlob.Builder builder() {
    return new ImmutableBlob.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlob ImmutableBlob}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Objects.Blob", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.IsObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.IsObject instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.Blob} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.Blob instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Objects.IsObject) {
        Objects.IsObject instance = (Objects.IsObject) object;
        id(instance.getId());
      }
      if (object instanceof Objects.Blob) {
        Objects.Blob instance = (Objects.Blob) object;
        value(instance.getValue());
      }
    }

    /**
     * Initializes the value for the {@link Objects.Blob#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = java.util.Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Blob#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = java.util.Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlob ImmutableBlob}.
     * @return An immutable instance of Blob
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlob build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBlob(id, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build Blob, some of required attributes are not set " + attributes;
    }
  }
}
