package io.resys.thena.docdb.spi.commits;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitVisitor.RedundentHashedBlob}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRedundentHashedBlob.builder()}.
 */
@Generated(from = "CommitVisitor.RedundentHashedBlob", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRedundentHashedBlob
    implements CommitVisitor.RedundentHashedBlob {
  private final String name;
  private final String hash;
  private final String blob;

  private ImmutableRedundentHashedBlob(String name, String hash, String blob) {
    this.name = name;
    this.hash = hash;
    this.blob = blob;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code blob} attribute
   */
  @Override
  public String getBlob() {
    return blob;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.RedundentHashedBlob#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedundentHashedBlob withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRedundentHashedBlob(newValue, this.hash, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.RedundentHashedBlob#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedundentHashedBlob withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableRedundentHashedBlob(this.name, newValue, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.RedundentHashedBlob#getBlob() blob} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blob
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedundentHashedBlob withBlob(String value) {
    String newValue = Objects.requireNonNull(value, "blob");
    if (this.blob.equals(newValue)) return this;
    return new ImmutableRedundentHashedBlob(this.name, this.hash, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRedundentHashedBlob} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRedundentHashedBlob
        && equalTo((ImmutableRedundentHashedBlob) another);
  }

  private boolean equalTo(ImmutableRedundentHashedBlob another) {
    return name.equals(another.name)
        && hash.equals(another.hash)
        && blob.equals(another.blob);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code hash}, {@code blob}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + blob.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RedundentHashedBlob} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RedundentHashedBlob")
        .omitNullValues()
        .add("name", name)
        .add("hash", hash)
        .add("blob", blob)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CommitVisitor.RedundentHashedBlob} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RedundentHashedBlob instance
   */
  public static ImmutableRedundentHashedBlob copyOf(CommitVisitor.RedundentHashedBlob instance) {
    if (instance instanceof ImmutableRedundentHashedBlob) {
      return (ImmutableRedundentHashedBlob) instance;
    }
    return ImmutableRedundentHashedBlob.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRedundentHashedBlob ImmutableRedundentHashedBlob}.
   * <pre>
   * ImmutableRedundentHashedBlob.builder()
   *    .name(String) // required {@link CommitVisitor.RedundentHashedBlob#getName() name}
   *    .hash(String) // required {@link CommitVisitor.RedundentHashedBlob#getHash() hash}
   *    .blob(String) // required {@link CommitVisitor.RedundentHashedBlob#getBlob() blob}
   *    .build();
   * </pre>
   * @return A new ImmutableRedundentHashedBlob builder
   */
  public static ImmutableRedundentHashedBlob.Builder builder() {
    return new ImmutableRedundentHashedBlob.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRedundentHashedBlob ImmutableRedundentHashedBlob}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitVisitor.RedundentHashedBlob", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_BLOB = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String name;
    private @Nullable String hash;
    private @Nullable String blob;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RedundentHashedBlob} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitVisitor.RedundentHashedBlob instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      hash(instance.getHash());
      blob(instance.getBlob());
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.RedundentHashedBlob#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.RedundentHashedBlob#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.RedundentHashedBlob#getBlob() blob} attribute.
     * @param blob The value for blob 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blob(String blob) {
      this.blob = Objects.requireNonNull(blob, "blob");
      initBits &= ~INIT_BIT_BLOB;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRedundentHashedBlob ImmutableRedundentHashedBlob}.
     * @return An immutable instance of RedundentHashedBlob
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRedundentHashedBlob build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRedundentHashedBlob(name, hash, blob);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_BLOB) != 0) attributes.add("blob");
      return "Cannot build RedundentHashedBlob, some of required attributes are not set " + attributes;
    }
  }
}
