package io.resys.thena.docdb.spi.commits;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitVisitor.CommitOutput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitOutput.builder()}.
 */
@Generated(from = "CommitVisitor.CommitOutput", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitOutput
    implements CommitVisitor.CommitOutput {
  private final CommitVisitor.CommitOutputStatus status;
  private final Repo repo;
  private final Message log;
  private final Objects.Ref ref;
  private final Objects.Commit commit;
  private final Objects.Tree tree;
  private final Collection<Objects.Blob> blobs;
  private final ImmutableList<Message> messages;

  private ImmutableCommitOutput(
      CommitVisitor.CommitOutputStatus status,
      Repo repo,
      Message log,
      Objects.Ref ref,
      Objects.Commit commit,
      Objects.Tree tree,
      Collection<Objects.Blob> blobs,
      ImmutableList<Message> messages) {
    this.status = status;
    this.repo = repo;
    this.log = log;
    this.ref = ref;
    this.commit = commit;
    this.tree = tree;
    this.blobs = blobs;
    this.messages = messages;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @Override
  public CommitVisitor.CommitOutputStatus getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code log} attribute
   */
  @Override
  public Message getLog() {
    return log;
  }

  /**
   * @return The value of the {@code ref} attribute
   */
  @Override
  public Objects.Ref getRef() {
    return ref;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public Objects.Commit getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code tree} attribute
   */
  @Override
  public Objects.Tree getTree() {
    return tree;
  }

  /**
   * @return The value of the {@code blobs} attribute
   */
  @Override
  public Collection<Objects.Blob> getBlobs() {
    return blobs;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @Override
  public ImmutableList<Message> getMessages() {
    return messages;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitOutput#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitOutput withStatus(CommitVisitor.CommitOutputStatus value) {
    if (this.status == value) return this;
    CommitVisitor.CommitOutputStatus newValue = java.util.Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableCommitOutput(newValue, this.repo, this.log, this.ref, this.commit, this.tree, this.blobs, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitOutput#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitOutput withRepo(Repo value) {
    if (this.repo == value) return this;
    Repo newValue = java.util.Objects.requireNonNull(value, "repo");
    return new ImmutableCommitOutput(this.status, newValue, this.log, this.ref, this.commit, this.tree, this.blobs, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitOutput#getLog() log} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for log
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitOutput withLog(Message value) {
    if (this.log == value) return this;
    Message newValue = java.util.Objects.requireNonNull(value, "log");
    return new ImmutableCommitOutput(this.status, this.repo, newValue, this.ref, this.commit, this.tree, this.blobs, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitOutput#getRef() ref} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitOutput withRef(Objects.Ref value) {
    if (this.ref == value) return this;
    Objects.Ref newValue = java.util.Objects.requireNonNull(value, "ref");
    return new ImmutableCommitOutput(this.status, this.repo, this.log, newValue, this.commit, this.tree, this.blobs, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitOutput#getCommit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitOutput withCommit(Objects.Commit value) {
    if (this.commit == value) return this;
    Objects.Commit newValue = java.util.Objects.requireNonNull(value, "commit");
    return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, newValue, this.tree, this.blobs, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitOutput#getTree() tree} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitOutput withTree(Objects.Tree value) {
    if (this.tree == value) return this;
    Objects.Tree newValue = java.util.Objects.requireNonNull(value, "tree");
    return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, newValue, this.blobs, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitOutput#getBlobs() blobs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blobs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitOutput withBlobs(Collection<Objects.Blob> value) {
    if (this.blobs == value) return this;
    Collection<Objects.Blob> newValue = java.util.Objects.requireNonNull(value, "blobs");
    return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, this.tree, newValue, this.messages);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitVisitor.CommitOutput#getMessages() messages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitOutput withMessages(Message... elements) {
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, this.tree, this.blobs, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitVisitor.CommitOutput#getMessages() messages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitOutput withMessages(Iterable<? extends Message> elements) {
    if (this.messages == elements) return this;
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitOutput(this.status, this.repo, this.log, this.ref, this.commit, this.tree, this.blobs, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitOutput
        && equalTo((ImmutableCommitOutput) another);
  }

  private boolean equalTo(ImmutableCommitOutput another) {
    return status.equals(another.status)
        && repo.equals(another.repo)
        && log.equals(another.log)
        && ref.equals(another.ref)
        && commit.equals(another.commit)
        && tree.equals(another.tree)
        && blobs.equals(another.blobs)
        && messages.equals(another.messages);
  }

  /**
   * Computes a hash code from attributes: {@code status}, {@code repo}, {@code log}, {@code ref}, {@code commit}, {@code tree}, {@code blobs}, {@code messages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + status.hashCode();
    h += (h << 5) + repo.hashCode();
    h += (h << 5) + log.hashCode();
    h += (h << 5) + ref.hashCode();
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + tree.hashCode();
    h += (h << 5) + blobs.hashCode();
    h += (h << 5) + messages.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CommitOutput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommitOutput")
        .omitNullValues()
        .add("status", status)
        .add("repo", repo)
        .add("log", log)
        .add("ref", ref)
        .add("commit", commit)
        .add("tree", tree)
        .add("blobs", blobs)
        .add("messages", messages)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CommitVisitor.CommitOutput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitOutput instance
   */
  public static ImmutableCommitOutput copyOf(CommitVisitor.CommitOutput instance) {
    if (instance instanceof ImmutableCommitOutput) {
      return (ImmutableCommitOutput) instance;
    }
    return ImmutableCommitOutput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitOutput ImmutableCommitOutput}.
   * <pre>
   * ImmutableCommitOutput.builder()
   *    .status(io.resys.thena.docdb.spi.commits.CommitVisitor.CommitOutputStatus) // required {@link CommitVisitor.CommitOutput#getStatus() status}
   *    .repo(io.resys.thena.docdb.api.models.Repo) // required {@link CommitVisitor.CommitOutput#getRepo() repo}
   *    .log(io.resys.thena.docdb.api.models.Message) // required {@link CommitVisitor.CommitOutput#getLog() log}
   *    .ref(io.resys.thena.docdb.api.models.Objects.Ref) // required {@link CommitVisitor.CommitOutput#getRef() ref}
   *    .commit(io.resys.thena.docdb.api.models.Objects.Commit) // required {@link CommitVisitor.CommitOutput#getCommit() commit}
   *    .tree(io.resys.thena.docdb.api.models.Objects.Tree) // required {@link CommitVisitor.CommitOutput#getTree() tree}
   *    .blobs(Collection&amp;lt;io.resys.thena.docdb.api.models.Objects.Blob&amp;gt;) // required {@link CommitVisitor.CommitOutput#getBlobs() blobs}
   *    .addMessages|addAllMessages(io.resys.thena.docdb.api.models.Message) // {@link CommitVisitor.CommitOutput#getMessages() messages} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCommitOutput builder
   */
  public static ImmutableCommitOutput.Builder builder() {
    return new ImmutableCommitOutput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitOutput ImmutableCommitOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitVisitor.CommitOutput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STATUS = 0x1L;
    private static final long INIT_BIT_REPO = 0x2L;
    private static final long INIT_BIT_LOG = 0x4L;
    private static final long INIT_BIT_REF = 0x8L;
    private static final long INIT_BIT_COMMIT = 0x10L;
    private static final long INIT_BIT_TREE = 0x20L;
    private static final long INIT_BIT_BLOBS = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable CommitVisitor.CommitOutputStatus status;
    private @Nullable Repo repo;
    private @Nullable Message log;
    private @Nullable Objects.Ref ref;
    private @Nullable Objects.Commit commit;
    private @Nullable Objects.Tree tree;
    private @Nullable Collection<Objects.Blob> blobs;
    private ImmutableList.Builder<Message> messages = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommitOutput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitVisitor.CommitOutput instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      status(instance.getStatus());
      repo(instance.getRepo());
      log(instance.getLog());
      ref(instance.getRef());
      commit(instance.getCommit());
      tree(instance.getTree());
      blobs(instance.getBlobs());
      addAllMessages(instance.getMessages());
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitOutput#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder status(CommitVisitor.CommitOutputStatus status) {
      this.status = java.util.Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitOutput#getRepo() repo} attribute.
     * @param repo The value for repo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(Repo repo) {
      this.repo = java.util.Objects.requireNonNull(repo, "repo");
      initBits &= ~INIT_BIT_REPO;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitOutput#getLog() log} attribute.
     * @param log The value for log 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder log(Message log) {
      this.log = java.util.Objects.requireNonNull(log, "log");
      initBits &= ~INIT_BIT_LOG;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitOutput#getRef() ref} attribute.
     * @param ref The value for ref 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ref(Objects.Ref ref) {
      this.ref = java.util.Objects.requireNonNull(ref, "ref");
      initBits &= ~INIT_BIT_REF;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitOutput#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(Objects.Commit commit) {
      this.commit = java.util.Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitOutput#getTree() tree} attribute.
     * @param tree The value for tree 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tree(Objects.Tree tree) {
      this.tree = java.util.Objects.requireNonNull(tree, "tree");
      initBits &= ~INIT_BIT_TREE;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitOutput#getBlobs() blobs} attribute.
     * @param blobs The value for blobs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobs(Collection<Objects.Blob> blobs) {
      this.blobs = java.util.Objects.requireNonNull(blobs, "blobs");
      initBits &= ~INIT_BIT_BLOBS;
      return this;
    }

    /**
     * Adds one element to {@link CommitVisitor.CommitOutput#getMessages() messages} list.
     * @param element A messages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(Message element) {
      this.messages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CommitVisitor.CommitOutput#getMessages() messages} list.
     * @param elements An array of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(Message... elements) {
      this.messages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitVisitor.CommitOutput#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder messages(Iterable<? extends Message> elements) {
      this.messages = ImmutableList.builder();
      return addAllMessages(elements);
    }

    /**
     * Adds elements to {@link CommitVisitor.CommitOutput#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMessages(Iterable<? extends Message> elements) {
      this.messages.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitOutput ImmutableCommitOutput}.
     * @return An immutable instance of CommitOutput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitOutput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommitOutput(status, repo, log, ref, commit, tree, blobs, messages.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_REPO) != 0) attributes.add("repo");
      if ((initBits & INIT_BIT_LOG) != 0) attributes.add("log");
      if ((initBits & INIT_BIT_REF) != 0) attributes.add("ref");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_TREE) != 0) attributes.add("tree");
      if ((initBits & INIT_BIT_BLOBS) != 0) attributes.add("blobs");
      return "Cannot build CommitOutput, some of required attributes are not set " + attributes;
    }
  }
}
