package io.resys.thena.docdb.spi.commits;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitVisitor.CommitInput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitInput.builder()}.
 */
@Generated(from = "CommitVisitor.CommitInput", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitInput implements CommitVisitor.CommitInput {
  private final @Nullable ObjectsActions.RefObjects parent;
  private final Repo repo;
  private final String ref;
  private final String commitAuthor;
  private final String commitMessage;
  private final ImmutableMap<String, String> append;
  private final Collection<String> remove;

  private ImmutableCommitInput(
      @Nullable ObjectsActions.RefObjects parent,
      Repo repo,
      String ref,
      String commitAuthor,
      String commitMessage,
      ImmutableMap<String, String> append,
      Collection<String> remove) {
    this.parent = parent;
    this.repo = repo;
    this.ref = ref;
    this.commitAuthor = commitAuthor;
    this.commitMessage = commitMessage;
    this.append = append;
    this.remove = remove;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @Override
  public Optional<ObjectsActions.RefObjects> getParent() {
    return Optional.ofNullable(parent);
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code ref} attribute
   */
  @Override
  public String getRef() {
    return ref;
  }

  /**
   * @return The value of the {@code commitAuthor} attribute
   */
  @Override
  public String getCommitAuthor() {
    return commitAuthor;
  }

  /**
   * @return The value of the {@code commitMessage} attribute
   */
  @Override
  public String getCommitMessage() {
    return commitMessage;
  }

  /**
   * @return The value of the {@code append} attribute
   */
  @Override
  public ImmutableMap<String, String> getAppend() {
    return append;
  }

  /**
   * @return The value of the {@code remove} attribute
   */
  @Override
  public Collection<String> getRemove() {
    return remove;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CommitVisitor.CommitInput#getParent() parent} attribute.
   * @param value The value for parent
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitInput withParent(ObjectsActions.RefObjects value) {
    @Nullable ObjectsActions.RefObjects newValue = Objects.requireNonNull(value, "parent");
    if (this.parent == newValue) return this;
    return new ImmutableCommitInput(newValue, this.repo, this.ref, this.commitAuthor, this.commitMessage, this.append, this.remove);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CommitVisitor.CommitInput#getParent() parent} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for parent
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCommitInput withParent(Optional<? extends ObjectsActions.RefObjects> optional) {
    @Nullable ObjectsActions.RefObjects value = optional.orElse(null);
    if (this.parent == value) return this;
    return new ImmutableCommitInput(value, this.repo, this.ref, this.commitAuthor, this.commitMessage, this.append, this.remove);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitInput#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitInput withRepo(Repo value) {
    if (this.repo == value) return this;
    Repo newValue = Objects.requireNonNull(value, "repo");
    return new ImmutableCommitInput(
        this.parent,
        newValue,
        this.ref,
        this.commitAuthor,
        this.commitMessage,
        this.append,
        this.remove);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitInput#getRef() ref} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitInput withRef(String value) {
    String newValue = Objects.requireNonNull(value, "ref");
    if (this.ref.equals(newValue)) return this;
    return new ImmutableCommitInput(
        this.parent,
        this.repo,
        newValue,
        this.commitAuthor,
        this.commitMessage,
        this.append,
        this.remove);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitInput#getCommitAuthor() commitAuthor} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitAuthor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitInput withCommitAuthor(String value) {
    String newValue = Objects.requireNonNull(value, "commitAuthor");
    if (this.commitAuthor.equals(newValue)) return this;
    return new ImmutableCommitInput(this.parent, this.repo, this.ref, newValue, this.commitMessage, this.append, this.remove);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitInput#getCommitMessage() commitMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitMessage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitInput withCommitMessage(String value) {
    String newValue = Objects.requireNonNull(value, "commitMessage");
    if (this.commitMessage.equals(newValue)) return this;
    return new ImmutableCommitInput(this.parent, this.repo, this.ref, this.commitAuthor, newValue, this.append, this.remove);
  }

  /**
   * Copy the current immutable object by replacing the {@link CommitVisitor.CommitInput#getAppend() append} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the append map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitInput withAppend(Map<String, ? extends String> entries) {
    if (this.append == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCommitInput(this.parent, this.repo, this.ref, this.commitAuthor, this.commitMessage, newValue, this.remove);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitVisitor.CommitInput#getRemove() remove} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for remove
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitInput withRemove(Collection<String> value) {
    if (this.remove == value) return this;
    Collection<String> newValue = Objects.requireNonNull(value, "remove");
    return new ImmutableCommitInput(this.parent, this.repo, this.ref, this.commitAuthor, this.commitMessage, this.append, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitInput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitInput
        && equalTo((ImmutableCommitInput) another);
  }

  private boolean equalTo(ImmutableCommitInput another) {
    return Objects.equals(parent, another.parent)
        && repo.equals(another.repo)
        && ref.equals(another.ref)
        && commitAuthor.equals(another.commitAuthor)
        && commitMessage.equals(another.commitMessage)
        && append.equals(another.append)
        && remove.equals(another.remove);
  }

  /**
   * Computes a hash code from attributes: {@code parent}, {@code repo}, {@code ref}, {@code commitAuthor}, {@code commitMessage}, {@code append}, {@code remove}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(parent);
    h += (h << 5) + repo.hashCode();
    h += (h << 5) + ref.hashCode();
    h += (h << 5) + commitAuthor.hashCode();
    h += (h << 5) + commitMessage.hashCode();
    h += (h << 5) + append.hashCode();
    h += (h << 5) + remove.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CommitInput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommitInput")
        .omitNullValues()
        .add("parent", parent)
        .add("repo", repo)
        .add("ref", ref)
        .add("commitAuthor", commitAuthor)
        .add("commitMessage", commitMessage)
        .add("append", append)
        .add("remove", remove)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CommitVisitor.CommitInput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitInput instance
   */
  public static ImmutableCommitInput copyOf(CommitVisitor.CommitInput instance) {
    if (instance instanceof ImmutableCommitInput) {
      return (ImmutableCommitInput) instance;
    }
    return ImmutableCommitInput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitInput ImmutableCommitInput}.
   * <pre>
   * ImmutableCommitInput.builder()
   *    .parent(io.resys.thena.docdb.api.actions.ObjectsActions.RefObjects) // optional {@link CommitVisitor.CommitInput#getParent() parent}
   *    .repo(io.resys.thena.docdb.api.models.Repo) // required {@link CommitVisitor.CommitInput#getRepo() repo}
   *    .ref(String) // required {@link CommitVisitor.CommitInput#getRef() ref}
   *    .commitAuthor(String) // required {@link CommitVisitor.CommitInput#getCommitAuthor() commitAuthor}
   *    .commitMessage(String) // required {@link CommitVisitor.CommitInput#getCommitMessage() commitMessage}
   *    .putAppend|putAllAppend(String =&gt; String) // {@link CommitVisitor.CommitInput#getAppend() append} mappings
   *    .remove(Collection&amp;lt;String&amp;gt;) // required {@link CommitVisitor.CommitInput#getRemove() remove}
   *    .build();
   * </pre>
   * @return A new ImmutableCommitInput builder
   */
  public static ImmutableCommitInput.Builder builder() {
    return new ImmutableCommitInput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitInput ImmutableCommitInput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitVisitor.CommitInput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REPO = 0x1L;
    private static final long INIT_BIT_REF = 0x2L;
    private static final long INIT_BIT_COMMIT_AUTHOR = 0x4L;
    private static final long INIT_BIT_COMMIT_MESSAGE = 0x8L;
    private static final long INIT_BIT_REMOVE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable ObjectsActions.RefObjects parent;
    private @Nullable Repo repo;
    private @Nullable String ref;
    private @Nullable String commitAuthor;
    private @Nullable String commitMessage;
    private ImmutableMap.Builder<String, String> append = ImmutableMap.builder();
    private @Nullable Collection<String> remove;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommitInput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitVisitor.CommitInput instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<ObjectsActions.RefObjects> parentOptional = instance.getParent();
      if (parentOptional.isPresent()) {
        parent(parentOptional);
      }
      repo(instance.getRepo());
      ref(instance.getRef());
      commitAuthor(instance.getCommitAuthor());
      commitMessage(instance.getCommitMessage());
      putAllAppend(instance.getAppend());
      remove(instance.getRemove());
      return this;
    }

    /**
     * Initializes the optional value {@link CommitVisitor.CommitInput#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(ObjectsActions.RefObjects parent) {
      this.parent = Objects.requireNonNull(parent, "parent");
      return this;
    }

    /**
     * Initializes the optional value {@link CommitVisitor.CommitInput#getParent() parent} to parent.
     * @param parent The value for parent
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parent(Optional<? extends ObjectsActions.RefObjects> parent) {
      this.parent = parent.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitInput#getRepo() repo} attribute.
     * @param repo The value for repo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(Repo repo) {
      this.repo = Objects.requireNonNull(repo, "repo");
      initBits &= ~INIT_BIT_REPO;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitInput#getRef() ref} attribute.
     * @param ref The value for ref 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ref(String ref) {
      this.ref = Objects.requireNonNull(ref, "ref");
      initBits &= ~INIT_BIT_REF;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitInput#getCommitAuthor() commitAuthor} attribute.
     * @param commitAuthor The value for commitAuthor 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitAuthor(String commitAuthor) {
      this.commitAuthor = Objects.requireNonNull(commitAuthor, "commitAuthor");
      initBits &= ~INIT_BIT_COMMIT_AUTHOR;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitInput#getCommitMessage() commitMessage} attribute.
     * @param commitMessage The value for commitMessage 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitMessage(String commitMessage) {
      this.commitMessage = Objects.requireNonNull(commitMessage, "commitMessage");
      initBits &= ~INIT_BIT_COMMIT_MESSAGE;
      return this;
    }

    /**
     * Put one entry to the {@link CommitVisitor.CommitInput#getAppend() append} map.
     * @param key The key in the append map
     * @param value The associated value in the append map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAppend(String key, String value) {
      this.append.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CommitVisitor.CommitInput#getAppend() append} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAppend(Map.Entry<String, ? extends String> entry) {
      this.append.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CommitVisitor.CommitInput#getAppend() append} map. Nulls are not permitted
     * @param entries The entries that will be added to the append map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder append(Map<String, ? extends String> entries) {
      this.append = ImmutableMap.builder();
      return putAllAppend(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CommitVisitor.CommitInput#getAppend() append} map. Nulls are not permitted
     * @param entries The entries that will be added to the append map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllAppend(Map<String, ? extends String> entries) {
      this.append.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link CommitVisitor.CommitInput#getRemove() remove} attribute.
     * @param remove The value for remove 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder remove(Collection<String> remove) {
      this.remove = Objects.requireNonNull(remove, "remove");
      initBits &= ~INIT_BIT_REMOVE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitInput ImmutableCommitInput}.
     * @return An immutable instance of CommitInput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitInput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommitInput(parent, repo, ref, commitAuthor, commitMessage, append.build(), remove);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REPO) != 0) attributes.add("repo");
      if ((initBits & INIT_BIT_REF) != 0) attributes.add("ref");
      if ((initBits & INIT_BIT_COMMIT_AUTHOR) != 0) attributes.add("commitAuthor");
      if ((initBits & INIT_BIT_COMMIT_MESSAGE) != 0) attributes.add("commitMessage");
      if ((initBits & INIT_BIT_REMOVE) != 0) attributes.add("remove");
      return "Cannot build CommitInput, some of required attributes are not set " + attributes;
    }
  }
}
