package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Objects}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableObjects.builder()}.
 */
@Generated(from = "Objects", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableObjects implements Objects {
  private final ImmutableMap<String, Objects.Ref> refs;
  private final ImmutableMap<String, Objects.Tag> tags;
  private final ImmutableMap<String, Objects.IsObject> values;

  private ImmutableObjects(
      ImmutableMap<String, Objects.Ref> refs,
      ImmutableMap<String, Objects.Tag> tags,
      ImmutableMap<String, Objects.IsObject> values) {
    this.refs = refs;
    this.tags = tags;
    this.values = values;
  }

  /**
   * @return The value of the {@code refs} attribute
   */
  @Override
  public ImmutableMap<String, Objects.Ref> getRefs() {
    return refs;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @Override
  public ImmutableMap<String, Objects.Tag> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  public ImmutableMap<String, Objects.IsObject> getValues() {
    return values;
  }

  /**
   * Copy the current immutable object by replacing the {@link Objects#getRefs() refs} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the refs map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableObjects withRefs(Map<String, ? extends Objects.Ref> entries) {
    if (this.refs == entries) return this;
    ImmutableMap<String, Objects.Ref> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableObjects(newValue, this.tags, this.values);
  }

  /**
   * Copy the current immutable object by replacing the {@link Objects#getTags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableObjects withTags(Map<String, ? extends Objects.Tag> entries) {
    if (this.tags == entries) return this;
    ImmutableMap<String, Objects.Tag> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableObjects(this.refs, newValue, this.values);
  }

  /**
   * Copy the current immutable object by replacing the {@link Objects#getValues() values} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the values map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableObjects withValues(Map<String, ? extends Objects.IsObject> entries) {
    if (this.values == entries) return this;
    ImmutableMap<String, Objects.IsObject> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableObjects(this.refs, this.tags, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableObjects} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableObjects
        && equalTo((ImmutableObjects) another);
  }

  private boolean equalTo(ImmutableObjects another) {
    return refs.equals(another.refs)
        && tags.equals(another.tags)
        && values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code refs}, {@code tags}, {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + refs.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Objects} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Objects")
        .omitNullValues()
        .add("refs", refs)
        .add("tags", tags)
        .add("values", values)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Objects} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Objects instance
   */
  public static ImmutableObjects copyOf(Objects instance) {
    if (instance instanceof ImmutableObjects) {
      return (ImmutableObjects) instance;
    }
    return ImmutableObjects.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableObjects ImmutableObjects}.
   * <pre>
   * ImmutableObjects.builder()
   *    .putRefs|putAllRefs(String =&gt; io.resys.thena.docdb.api.models.Objects.Ref) // {@link Objects#getRefs() refs} mappings
   *    .putTags|putAllTags(String =&gt; io.resys.thena.docdb.api.models.Objects.Tag) // {@link Objects#getTags() tags} mappings
   *    .putValues|putAllValues(String =&gt; io.resys.thena.docdb.api.models.Objects.IsObject) // {@link Objects#getValues() values} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableObjects builder
   */
  public static ImmutableObjects.Builder builder() {
    return new ImmutableObjects.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableObjects ImmutableObjects}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Objects", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<String, Objects.Ref> refs = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Objects.Tag> tags = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Objects.IsObject> values = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Objects} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      putAllRefs(instance.getRefs());
      putAllTags(instance.getTags());
      putAllValues(instance.getValues());
      return this;
    }

    /**
     * Put one entry to the {@link Objects#getRefs() refs} map.
     * @param key The key in the refs map
     * @param value The associated value in the refs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putRefs(String key, Objects.Ref value) {
      this.refs.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Objects#getRefs() refs} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putRefs(Map.Entry<String, ? extends Objects.Ref> entry) {
      this.refs.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Objects#getRefs() refs} map. Nulls are not permitted
     * @param entries The entries that will be added to the refs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder refs(Map<String, ? extends Objects.Ref> entries) {
      this.refs = ImmutableMap.builder();
      return putAllRefs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Objects#getRefs() refs} map. Nulls are not permitted
     * @param entries The entries that will be added to the refs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllRefs(Map<String, ? extends Objects.Ref> entries) {
      this.refs.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link Objects#getTags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTags(String key, Objects.Tag value) {
      this.tags.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Objects#getTags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTags(Map.Entry<String, ? extends Objects.Tag> entry) {
      this.tags.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Objects#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tags(Map<String, ? extends Objects.Tag> entries) {
      this.tags = ImmutableMap.builder();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Objects#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTags(Map<String, ? extends Objects.Tag> entries) {
      this.tags.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link Objects#getValues() values} map.
     * @param key The key in the values map
     * @param value The associated value in the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValues(String key, Objects.IsObject value) {
      this.values.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Objects#getValues() values} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putValues(Map.Entry<String, ? extends Objects.IsObject> entry) {
      this.values.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Objects#getValues() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder values(Map<String, ? extends Objects.IsObject> entries) {
      this.values = ImmutableMap.builder();
      return putAllValues(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Objects#getValues() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllValues(Map<String, ? extends Objects.IsObject> entries) {
      this.values.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableObjects ImmutableObjects}.
     * @return An immutable instance of Objects
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableObjects build() {
      return new ImmutableObjects(refs.build(), tags.build(), values.build());
    }
  }
}
