package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Diff.DiffBlob}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiffBlob.builder()}.
 */
@Generated(from = "Diff.DiffBlob", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDiffBlob implements Diff.DiffBlob {
  private final String id;
  private final String name;
  private final String content;

  private ImmutableDiffBlob(String id, String name, String content) {
    this.id = id;
    this.name = name;
    this.content = content;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public String getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.DiffBlob#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffBlob withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDiffBlob(newValue, this.name, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.DiffBlob#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffBlob withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableDiffBlob(this.id, newValue, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.DiffBlob#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffBlob withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutableDiffBlob(this.id, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiffBlob} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiffBlob
        && equalTo((ImmutableDiffBlob) another);
  }

  private boolean equalTo(ImmutableDiffBlob another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && content.equals(another.content);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + content.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DiffBlob} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DiffBlob")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("content", content)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Diff.DiffBlob} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DiffBlob instance
   */
  public static ImmutableDiffBlob copyOf(Diff.DiffBlob instance) {
    if (instance instanceof ImmutableDiffBlob) {
      return (ImmutableDiffBlob) instance;
    }
    return ImmutableDiffBlob.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiffBlob ImmutableDiffBlob}.
   * <pre>
   * ImmutableDiffBlob.builder()
   *    .id(String) // required {@link Diff.DiffBlob#getId() id}
   *    .name(String) // required {@link Diff.DiffBlob#getName() name}
   *    .content(String) // required {@link Diff.DiffBlob#getContent() content}
   *    .build();
   * </pre>
   * @return A new ImmutableDiffBlob builder
   */
  public static ImmutableDiffBlob.Builder builder() {
    return new ImmutableDiffBlob.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDiffBlob ImmutableDiffBlob}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Diff.DiffBlob", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_CONTENT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DiffBlob} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Diff.DiffBlob instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      content(instance.getContent());
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.DiffBlob#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.DiffBlob#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.DiffBlob#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiffBlob ImmutableDiffBlob}.
     * @return An immutable instance of DiffBlob
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiffBlob build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDiffBlob(id, name, content);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build DiffBlob, some of required attributes are not set " + attributes;
    }
  }
}
