package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TagActions.TagResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTagResult.builder()}.
 */
@Generated(from = "TagActions.TagResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTagResult implements TagActions.TagResult {
  private final @Nullable Objects.Tag tag;
  private final TagActions.TagStatus status;
  private final ImmutableList<Message> messages;

  private ImmutableTagResult(
      @Nullable Objects.Tag tag,
      TagActions.TagStatus status,
      ImmutableList<Message> messages) {
    this.tag = tag;
    this.status = status;
    this.messages = messages;
  }

  /**
   * @return The value of the {@code tag} attribute
   */
  @Override
  public @Nullable Objects.Tag getTag() {
    return tag;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @Override
  public TagActions.TagStatus getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @Override
  public ImmutableList<Message> getMessages() {
    return messages;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TagActions.TagResult#getTag() tag} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tag (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTagResult withTag(@Nullable Objects.Tag value) {
    if (this.tag == value) return this;
    return new ImmutableTagResult(value, this.status, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TagActions.TagResult#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTagResult withStatus(TagActions.TagStatus value) {
    if (this.status == value) return this;
    TagActions.TagStatus newValue = java.util.Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableTagResult(this.tag, newValue, this.messages);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TagActions.TagResult#getMessages() messages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTagResult withMessages(Message... elements) {
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTagResult(this.tag, this.status, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TagActions.TagResult#getMessages() messages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTagResult withMessages(Iterable<? extends Message> elements) {
    if (this.messages == elements) return this;
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTagResult(this.tag, this.status, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTagResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTagResult
        && equalTo((ImmutableTagResult) another);
  }

  private boolean equalTo(ImmutableTagResult another) {
    return java.util.Objects.equals(tag, another.tag)
        && status.equals(another.status)
        && messages.equals(another.messages);
  }

  /**
   * Computes a hash code from attributes: {@code tag}, {@code status}, {@code messages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + java.util.Objects.hashCode(tag);
    h += (h << 5) + status.hashCode();
    h += (h << 5) + messages.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TagResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TagResult")
        .omitNullValues()
        .add("tag", tag)
        .add("status", status)
        .add("messages", messages)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TagActions.TagResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TagResult instance
   */
  public static ImmutableTagResult copyOf(TagActions.TagResult instance) {
    if (instance instanceof ImmutableTagResult) {
      return (ImmutableTagResult) instance;
    }
    return ImmutableTagResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTagResult ImmutableTagResult}.
   * <pre>
   * ImmutableTagResult.builder()
   *    .tag(io.resys.thena.docdb.api.models.Objects.Tag | null) // nullable {@link TagActions.TagResult#getTag() tag}
   *    .status(io.resys.thena.docdb.api.actions.TagActions.TagStatus) // required {@link TagActions.TagResult#getStatus() status}
   *    .addMessages|addAllMessages(io.resys.thena.docdb.api.models.Message) // {@link TagActions.TagResult#getMessages() messages} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTagResult builder
   */
  public static ImmutableTagResult.Builder builder() {
    return new ImmutableTagResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTagResult ImmutableTagResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TagActions.TagResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STATUS = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Objects.Tag tag;
    private @Nullable TagActions.TagStatus status;
    private ImmutableList.Builder<Message> messages = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TagResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TagActions.TagResult instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      @Nullable Objects.Tag tagValue = instance.getTag();
      if (tagValue != null) {
        tag(tagValue);
      }
      status(instance.getStatus());
      addAllMessages(instance.getMessages());
      return this;
    }

    /**
     * Initializes the value for the {@link TagActions.TagResult#getTag() tag} attribute.
     * @param tag The value for tag (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tag(@Nullable Objects.Tag tag) {
      this.tag = tag;
      return this;
    }

    /**
     * Initializes the value for the {@link TagActions.TagResult#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder status(TagActions.TagStatus status) {
      this.status = java.util.Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Adds one element to {@link TagActions.TagResult#getMessages() messages} list.
     * @param element A messages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(Message element) {
      this.messages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TagActions.TagResult#getMessages() messages} list.
     * @param elements An array of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(Message... elements) {
      this.messages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TagActions.TagResult#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder messages(Iterable<? extends Message> elements) {
      this.messages = ImmutableList.builder();
      return addAllMessages(elements);
    }

    /**
     * Adds elements to {@link TagActions.TagResult#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMessages(Iterable<? extends Message> elements) {
      this.messages.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTagResult ImmutableTagResult}.
     * @return An immutable instance of TagResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTagResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTagResult(tag, status, messages.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build TagResult, some of required attributes are not set " + attributes;
    }
  }
}
