package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HistoryActions.HistoryResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHistoryResult.builder()}.
 */
@Generated(from = "HistoryActions.HistoryResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHistoryResult
    implements HistoryActions.HistoryResult {
  private final String value;
  private final String commit;
  private final LocalDateTime created;

  private ImmutableHistoryResult(String value, String commit, LocalDateTime created) {
    this.value = value;
    this.commit = commit;
    this.created = created;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public String getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HistoryActions.HistoryResult#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHistoryResult withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableHistoryResult(newValue, this.commit, this.created);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HistoryActions.HistoryResult#getCommit() commit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHistoryResult withCommit(String value) {
    String newValue = Objects.requireNonNull(value, "commit");
    if (this.commit.equals(newValue)) return this;
    return new ImmutableHistoryResult(this.value, newValue, this.created);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HistoryActions.HistoryResult#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHistoryResult withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableHistoryResult(this.value, this.commit, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHistoryResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHistoryResult
        && equalTo((ImmutableHistoryResult) another);
  }

  private boolean equalTo(ImmutableHistoryResult another) {
    return value.equals(another.value)
        && commit.equals(another.commit)
        && created.equals(another.created);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code commit}, {@code created}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + created.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HistoryResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HistoryResult")
        .omitNullValues()
        .add("value", value)
        .add("commit", commit)
        .add("created", created)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link HistoryActions.HistoryResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HistoryResult instance
   */
  public static ImmutableHistoryResult copyOf(HistoryActions.HistoryResult instance) {
    if (instance instanceof ImmutableHistoryResult) {
      return (ImmutableHistoryResult) instance;
    }
    return ImmutableHistoryResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHistoryResult ImmutableHistoryResult}.
   * <pre>
   * ImmutableHistoryResult.builder()
   *    .value(String) // required {@link HistoryActions.HistoryResult#getValue() value}
   *    .commit(String) // required {@link HistoryActions.HistoryResult#getCommit() commit}
   *    .created(java.time.LocalDateTime) // required {@link HistoryActions.HistoryResult#getCreated() created}
   *    .build();
   * </pre>
   * @return A new ImmutableHistoryResult builder
   */
  public static ImmutableHistoryResult.Builder builder() {
    return new ImmutableHistoryResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHistoryResult ImmutableHistoryResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HistoryActions.HistoryResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private static final long INIT_BIT_CREATED = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String value;
    private @Nullable String commit;
    private @Nullable LocalDateTime created;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HistoryResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HistoryActions.HistoryResult instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      commit(instance.getCommit());
      created(instance.getCreated());
      return this;
    }

    /**
     * Initializes the value for the {@link HistoryActions.HistoryResult#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link HistoryActions.HistoryResult#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(String commit) {
      this.commit = Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link HistoryActions.HistoryResult#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHistoryResult ImmutableHistoryResult}.
     * @return An immutable instance of HistoryResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHistoryResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHistoryResult(value, commit, created);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      return "Cannot build HistoryResult, some of required attributes are not set " + attributes;
    }
  }
}
