package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ObjectsActions.CommitObjects}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitObjects.builder()}.
 */
@Generated(from = "ObjectsActions.CommitObjects", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitObjects
    implements ObjectsActions.CommitObjects {
  private final Repo repo;
  private final Objects.Commit commit;
  private final Objects.Tree tree;
  private final ImmutableMap<String, Objects.Blob> blobs;

  private ImmutableCommitObjects(
      Repo repo,
      Objects.Commit commit,
      Objects.Tree tree,
      ImmutableMap<String, Objects.Blob> blobs) {
    this.repo = repo;
    this.commit = commit;
    this.tree = tree;
    this.blobs = blobs;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public Objects.Commit getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code tree} attribute
   */
  @Override
  public Objects.Tree getTree() {
    return tree;
  }

  /**
   * @return The value of the {@code blobs} attribute
   */
  @Override
  public ImmutableMap<String, Objects.Blob> getBlobs() {
    return blobs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.CommitObjects#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitObjects withRepo(Repo value) {
    if (this.repo == value) return this;
    Repo newValue = java.util.Objects.requireNonNull(value, "repo");
    return new ImmutableCommitObjects(newValue, this.commit, this.tree, this.blobs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.CommitObjects#getCommit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitObjects withCommit(Objects.Commit value) {
    if (this.commit == value) return this;
    Objects.Commit newValue = java.util.Objects.requireNonNull(value, "commit");
    return new ImmutableCommitObjects(this.repo, newValue, this.tree, this.blobs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.CommitObjects#getTree() tree} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitObjects withTree(Objects.Tree value) {
    if (this.tree == value) return this;
    Objects.Tree newValue = java.util.Objects.requireNonNull(value, "tree");
    return new ImmutableCommitObjects(this.repo, this.commit, newValue, this.blobs);
  }

  /**
   * Copy the current immutable object by replacing the {@link ObjectsActions.CommitObjects#getBlobs() blobs} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the blobs map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitObjects withBlobs(Map<String, ? extends Objects.Blob> entries) {
    if (this.blobs == entries) return this;
    ImmutableMap<String, Objects.Blob> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCommitObjects(this.repo, this.commit, this.tree, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitObjects} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitObjects
        && equalTo((ImmutableCommitObjects) another);
  }

  private boolean equalTo(ImmutableCommitObjects another) {
    return repo.equals(another.repo)
        && commit.equals(another.commit)
        && tree.equals(another.tree)
        && blobs.equals(another.blobs);
  }

  /**
   * Computes a hash code from attributes: {@code repo}, {@code commit}, {@code tree}, {@code blobs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + repo.hashCode();
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + tree.hashCode();
    h += (h << 5) + blobs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CommitObjects} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommitObjects")
        .omitNullValues()
        .add("repo", repo)
        .add("commit", commit)
        .add("tree", tree)
        .add("blobs", blobs)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ObjectsActions.CommitObjects} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitObjects instance
   */
  public static ImmutableCommitObjects copyOf(ObjectsActions.CommitObjects instance) {
    if (instance instanceof ImmutableCommitObjects) {
      return (ImmutableCommitObjects) instance;
    }
    return ImmutableCommitObjects.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitObjects ImmutableCommitObjects}.
   * <pre>
   * ImmutableCommitObjects.builder()
   *    .repo(io.resys.thena.docdb.api.models.Repo) // required {@link ObjectsActions.CommitObjects#getRepo() repo}
   *    .commit(io.resys.thena.docdb.api.models.Objects.Commit) // required {@link ObjectsActions.CommitObjects#getCommit() commit}
   *    .tree(io.resys.thena.docdb.api.models.Objects.Tree) // required {@link ObjectsActions.CommitObjects#getTree() tree}
   *    .putBlobs|putAllBlobs(String =&gt; io.resys.thena.docdb.api.models.Objects.Blob) // {@link ObjectsActions.CommitObjects#getBlobs() blobs} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableCommitObjects builder
   */
  public static ImmutableCommitObjects.Builder builder() {
    return new ImmutableCommitObjects.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitObjects ImmutableCommitObjects}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ObjectsActions.CommitObjects", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REPO = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private static final long INIT_BIT_TREE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Repo repo;
    private @Nullable Objects.Commit commit;
    private @Nullable Objects.Tree tree;
    private ImmutableMap.Builder<String, Objects.Blob> blobs = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommitObjects} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ObjectsActions.CommitObjects instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      repo(instance.getRepo());
      commit(instance.getCommit());
      tree(instance.getTree());
      putAllBlobs(instance.getBlobs());
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.CommitObjects#getRepo() repo} attribute.
     * @param repo The value for repo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(Repo repo) {
      this.repo = java.util.Objects.requireNonNull(repo, "repo");
      initBits &= ~INIT_BIT_REPO;
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.CommitObjects#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(Objects.Commit commit) {
      this.commit = java.util.Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.CommitObjects#getTree() tree} attribute.
     * @param tree The value for tree 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tree(Objects.Tree tree) {
      this.tree = java.util.Objects.requireNonNull(tree, "tree");
      initBits &= ~INIT_BIT_TREE;
      return this;
    }

    /**
     * Put one entry to the {@link ObjectsActions.CommitObjects#getBlobs() blobs} map.
     * @param key The key in the blobs map
     * @param value The associated value in the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBlobs(String key, Objects.Blob value) {
      this.blobs.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ObjectsActions.CommitObjects#getBlobs() blobs} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBlobs(Map.Entry<String, ? extends Objects.Blob> entry) {
      this.blobs.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ObjectsActions.CommitObjects#getBlobs() blobs} map. Nulls are not permitted
     * @param entries The entries that will be added to the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobs(Map<String, ? extends Objects.Blob> entries) {
      this.blobs = ImmutableMap.builder();
      return putAllBlobs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ObjectsActions.CommitObjects#getBlobs() blobs} map. Nulls are not permitted
     * @param entries The entries that will be added to the blobs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllBlobs(Map<String, ? extends Objects.Blob> entries) {
      this.blobs.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitObjects ImmutableCommitObjects}.
     * @return An immutable instance of CommitObjects
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitObjects build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommitObjects(repo, commit, tree, blobs.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REPO) != 0) attributes.add("repo");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_TREE) != 0) attributes.add("tree");
      return "Cannot build CommitObjects, some of required attributes are not set " + attributes;
    }
  }
}
